#ifndef _Bob_H_
#define _Bob_H_

/**
* @file Bob.h
* @brief collection of some functions to communicate
* with the processor board. LEDs, SD, etc.
*
* @author Bob Giesberts
*
* @date 2015-12-18
*/

#include "mbed.h"
#include "mbed_debug.h"
#include "PinDetect.h"
#include "WakeUp.h"

class Bob {
    public:
    
        /** Construct a new instance of the class Bob
         * @param process_led   Pin connected to the green led, used for processing
         * @param error_led     Pin connected to the red led, used for errors
         * @param button        Pin connected to the I/O button
         * @param enable        Pin connected to the SD card system and the crystal
         * @param sd_present    Pin connected to the SDCardDetect port
         * @param battery       Pin connected to the battery
         */
        Bob(PinName process_led, PinName error_led, PinName button, PinName enable, PinName sd_present, PinName battery);
        ~Bob();
        
        bool checkSD(void);
        
        void wakeup_periphery(void);
        
        /** shutdown_periphery
         *  Powers down the SD card system, the crystal and the LDC1614
         */
        void shutdown_periphery(void);
        void shutdown_pin(PinName pin, int value = 0, PinMode pull = PullNone );
        void sleep(uint32_t ms);
        

        float battery(void);
        
        void flash(int n, int led = 0 );
        void processing( int n = 0 );
        void no_processing(void);
        void error( int n = 0 );
        void no_error(void);
            
    private:
        DigitalOut _led_process;    // green led
        DigitalOut _led_error;      // red led
        PinDetect  _button;         // button
        DigitalOut _enable;         // pin to power all periphery (SD, crystal, LDC1614)
        
        DigitalIn *_sd_card_detect;
        
        AnalogIn  *_batt;

};

#endif