/**
* @file Bob.cpp
* @brief just some functions to communicate with the
* processor board for the LDC1614
*
* @author Bob Giesberts
*
* @date 2016-08-24
*/

#include "Bob.h"



void keyPressed( void )
{
    // do something
    debug( "button pressed\r\n" );
}



Bob::Bob(PinName process_led, PinName error_led, PinName button, PinName enable, PinName sd_present, PinName battery) : _led_process(process_led), _led_error(error_led), _button(button), _enable(enable)
{
    // setup leds
    _led_process = 0;   // green
    _led_error = 0;     // red

    // setup I/O button 
    _button.mode( PullUp );
    wait_ms(1);
    _button.attach_asserted( &keyPressed );
    _button.setSampleFrequency();

    // setup SD card system
    _sd_card_detect = new DigitalIn( sd_present ); 
    _sd_card_detect->mode( PullUp );

    // setup battery
    _batt = new AnalogIn( battery );
    
}

Bob::~Bob() {}



bool Bob::checkSD(void)
{
    // TODO: this should first check if _enable is on. if not, return false either way!
    
    _enable.write(1);
    wait_ms(3); 
    return !_sd_card_detect->read();
}

void Bob::wakeup_periphery(void)
{
    _enable.write(1);      // power SD-card
    wait_ms(3);   
    // wait(0.3);          // this shouldn't be necessary because loading the LDC library already takes 0.81 s
}

void Bob::shutdown_periphery(void)
{
    _enable.write(0);
}

void Bob::shutdown_pin(PinName pin, int value, PinMode pull )
{
    if( value == 1 )
    {
        DigitalInOut *_pin = new DigitalInOut( pin );
        _pin->output();
        _pin->mode( pull );
        _pin->write( value );
        delete _pin;
        _pin = NULL;
    }else{
        DigitalOut *_pin = new DigitalOut( pin );
        _pin->write( value );
        delete _pin;
        _pin = NULL;
    }
}

void Bob::sleep(uint32_t ms)
{
     WakeUp::calibrate();           // calibration takes 100 ms
     WakeUp::set_ms( ms - 100 );    // substract this from the total sleep time
     deepsleep();
}

// battery voltage should be 3.1V (min) < 3.7V (typ) < 4.22V (max)
float Bob::battery(void)
{
    return (float)_batt->read() * 3.0 * 2.0;
}

void Bob::flash( int n, int led )
{
    if( led == 0 || led == 1 ) _led_process = 0;
    if( led == 0 || led == 2 ) _led_error = 0;
    for(int i=0; i<n*2; i++){
        if( led == 0 || led == 1 ) _led_process = 1-_led_process; 
        if( led == 0 || led == 2 ) _led_error = 1-_led_error; 
        wait(0.2);
    }
}

void Bob::processing( int n)
{
    if( n == 0 ) {
        _led_process = 1; 
    }else{
        _led_process = 0;
        flash( n, 1 );
        wait(0.8);
    }     
}
void Bob::no_processing(void)  { _led_process   = 0; }

void Bob::error( int n )
{
    if( n == 0 ) {
        _led_error = 1; 
    }else{
        _led_error = 0;
        flash( n, 2 );
        wait(0.8);
    }     
}
void Bob::no_error(void)  { _led_error   = 0; }
