#include "SRF02.h"

/* Creates an instance of class. Setting the pin used for I2C, the address of device and the measure range type. */
SRF02::SRF02(PinName sda, PinName scl, int addr, char type) : _i2c(sda, scl), _addr(addr)
{
    _typem = type;
}

/* Destroyer of class instance. */
SRF02::~SRF02() 
{

}

/* Start and return the range measure. */
float SRF02::read() 
{
    char command[2];
    char result[2];

    command[0] = 0x00;                          // Set the command register
    command[1] = _typem;                        // Ranging results in type indicated in a costructor
    _i2c.write(_addr, command, 2);              // Send the command to start a ranging burst

    wait_ms(70);                                // Wait 70mS for complete the measure

    command[0] = 0x02;                          // The start address of measure result
    _i2c.write(_addr, command, 1, 1);           // Send address to read a measure
    _i2c.read(_addr, result, 2);                // Read two byte of measure

    float range = (result[0]<<8)+result[1];     // Convert the two byte in a float value

    return range;
}
