/* A simple IO demo using the MCP23S17 library
* Copyright (c) 2010 Romilly Cocking
* Released under the MIT License: http://mbed.org/license/mit
*
* See http://mbed.org/users/romilly/notebook/mcp23s17-addressable-16-bit-io-expander-with-spi/
*

* MCP23S17 datasheet http://ww1.microchip.com/downloads/en/DeviceDoc/21952b.pdf
* version 0.4
*/
#include "mbed.h"
#include "MCP23S17.h"

SPI spi(p5, p6, p7);
// Create SPI bus
// mbed p5,p6,p7 are tied to MCP23S17 SI, SO, SCK pins
// A0, A1, A2 of the MCP23S17  are tied to ground on the breadboard, so the 8-bit address for writes is 0x40
// This is referred to as the opcode in the device datasheet
char writeOpcode = 0x40;

// Next create a MCP23S17
// mbed p20 is connected to ~chipSelect on the MCP23S17
MCP23S17 chip = MCP23S17(spi, p20, writeOpcode);

DigitalOut led1(LED1); // mbed LED1 is used for test status display

int main() {
//  Nothing has to be connected to the MCP23S17 reset pin since it has a power on reset circuit.
//  It can be used for a software forced reset by pulling it low with an mbed GPIO pin.
//  But just leave it unconnected for this simple demo code. It is possible to lock up the chip
//  if you happen to reset the mbed in the middle of an SPI transfer (not too likely). 
//  If it happens just remove and attach the USB cable to reset by cycling the power.
//  After a power on reset, both IO ports default to input mode
//
//  Set all 8 Port A bits to output direction
    chip.direction(PORT_A, 0x00);
//  Set all 8 Port B bits to input direction
    chip.direction(PORT_B, 0xFF);
    led1=0;
//  Start Loopback test sending out and reading back values
//  loopback test uses A0 and B0 pins - so use a wire to jumper those two pins on MCP23S17 together
    while (1) {
        // write 0xAA to MCP23S17 Port A
        chip.write(PORT_A, 0xAA);
        wait(.5);
        // read back value from MCP23S17 Port B and display B0 on mbed led1
        led1 = chip.read(PORT_B)& 0x01;
        // write 0x55 to MCP23S17 Port A
        chip.write(PORT_A, 0x55);
        wait(.5);
        // read back value from MCP23S17 Port B and display B0 on mbed led1
        led1 = chip.read(PORT_B)& 0x01;
        // led1 should blink slowly if it is all working
    }
}
