#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);//Lcd and connections

InterruptIn joystickcenter(p14);//Pushbutton on center of joystick
Timer debounce; // define debounce timer

AnalogIn pot1(p19); // Pot 1-Program setpoint.Tank level setpoint
AnalogIn pot2(p20); // Pot 2-Program variable.Simulate output flow from tank. Process variable (PV)

DigitalOut led(LED1);
DigitalOut led4(LED4);

PwmOut red(p23); //RGB LED with 3 PWM outputs for dimmer control
PwmOut green(p24);//Green Led- Status OK
PwmOut blue(p25);//Red Led- Alarm Condition
PwmOut speaker(p26); //Onboard Speaker- Audible alarm

Serial pc(USBTX,USBRX); // Printf to PC over USB

void flip()
{

    if (debounce.read_ms()>200) { // only allow toggle if debounce timer has passed 200ms
        led4 =!led4;// Invert Led4
        debounce.reset(); // restart timer when
        wait(0.5);//pause before moving on in program
    }

}

int main ()
    {
    float  pv ;
    float  setpoint;

    joystickcenter.rise(&flip); // attach the function address to the rising edge

    speaker.period(1.0/1000.0); // 1000hz period
    red=1.0; //RGB LED off - PWM 100% duty cycle
    green=1.0;
    blue=1.0;//Not used in project


    while (1) {//continuous loop

        lcd.cls();//clears LCD
        lcd.locate(0,0); // Lcd coordinates
        pv = pot2;//read simulated output flow
        pv = 100.0 * pot2; // Tank level simulated value in %
        lcd.printf("Tank Level = %.1f\n\r",pv);
        setpoint = pot1;// Level simulated setpoint
        setpoint = 100.0 * pot1; // Tank level setpoint in %
        lcd.printf("Setpoint = %.1f\n\r",setpoint);
        debounce.start();//Start of the debounce timer
        
        //Serial interface
        pc.printf("Tank Level = %.1f\n\r",pv); //send tank level to PC
        pc.printf("          Level setpoint = %.1f\n\r",setpoint); //send setpoint to PC with spacing for clarity
        wait(0.5);//pause before moving on in program

        if(pv <= setpoint) { // Determines action of inputs pot1 and pot2
            red = 1.0 - pot2; //RGB LED red
            green = 1.0;
            led=1.0;
            speaker = 0.5; //alarm tone using Pwm
            pc.printf(" Alarm!! Tank Level Low....Top-up valve open\n"); //send setpoint to PC
            wait(0.5);

        } else {
            green = 1.0 - pot2; //RGB LED green
            red = 1.0;
            led=0.0;
            speaker = 0.0;
            wait(0.5);
        }
        if (led4) {
            pc.printf("................. Outlet valve open\n\r");
            wait(0.5);
        } else {
            pc.printf("**\n\r");// No alarm
            wait(0.5);
     }

  }

}
