#include "mbed.h"

DigitalIn fire(p14);
PwmOut spkr(p26);
AnalogIn pot1(p19);

float start=2000.0;// Value for lowest tone
float end=10000.0;// Value for highest tone
float step=1000.0;//step increase between lowest and highest tone

int main()

{
    while (1) {
        {
            for (float i= start; i<end; i+=step)// Sequence 1
             {
                spkr.period(1.0/i);//Frequency
                spkr=0.5 ;// PWM duty cycle of output to speaker
                wait(0.1);// Time period between steps
            }
            
                for (float i= (start+1000.0); i<(end-1000.0); i+=(step+500.0))//Sequence 2
                {
                    spkr.period(1.0/i);
                    spkr=0.9;
                    wait(0.4);// Time period between steps
                }
            
            spkr=0.0;
            while(pot1.read() < 0.5) {} // Pot initializes the start of the routine
        }
    }
}