//
// This module implements ACA Charge mode for USB connected phones to external charge source.
// A state-machine is required that runs when phone is attached/detached 
//

#include "ACA.h"

// ACA Charger state machine
#define IDLE_STATE      0
#define WAIT_STATE      1

static  int state=WAIT_STATE;
static  int delay = 0;

// Runs every 20ms for now
// For now we just set the ID resistors to there default settings
void ACAChargerTask()
{
    switch(state)
    {
        case WAIT_STATE:
            disableVBUS = 1;    // disable VBUS
            ID_SW = 1;          // Enable 124k ID res
            ID_SW1 = 0; 
            delay++;
            if(delay==20) {     // delay 400ms
                state = IDLE_STATE;
                delay=0;
            }
        break;
        
        case IDLE_STATE:
             disableVBUS = 0;   //Enable VBUS, stay in this state till next power cycle
        break;
        
        
        default:
        break;
        
    }
}

