#pragma once

#ifndef _LASER_
#define _LASER_

#include <stdio.h>
#include <vector>

#include "mbed.h"

using namespace std;


class Laser
{
public:
    Laser(Serial& serial, int nSamples = 10);
    ~Laser();

    void enableMeasurement(bool enable);
    void triggerDistanceMeasurement();
    void setDistaceCallback(void (*distanceCallback)(float distance, float elapsedTime));
    void setDebugCallback(void (*debugCallback)(char*));
    void setRedDot(bool on);
    void turnLaserPowerOn();
    void turnLaserPowerOff();
    void setNumberOfSamples(int n) {nSamples = n;}

private:
    bool timerRunning;
    uint8_t idx;
    Serial& serial;
    bool powerOffState; 
    bool busy;
    int nSamples;
    
    static const uint8_t bufSize = 100;
    char buf[bufSize];
    Timer timer;
    bool sendCommand(char cmd[]);
    bool processResponse();
    void split(char s[], char c, std::vector<char*>& v);
    void (*distanceCallback)(float distance, float elapsedTime);
    void (*debugCallback)(char data[]);
    void discardResponse();
    void connectPower();
    void removePower();
};

#endif // _LASER_