
#ifndef __BLE_HELPER_H__
#define __BLE_HELPER_H__

#include "mbed.h"
#include "Serial.h"
#include "BLE.h"
#include "DeviceInformationService.h"
#include "UARTService.h"


/* helper class to break larger than 20 byte limit of a BLE payload to smaller multiple
   packets and send over the BLE connection */
class BLEHelper
{
public:
    // constructor
    BLEHelper(BLEDevice* ble, UARTService* UuartServicePtr);
    void sendPacketOverBLE(uint16_t cmd, uint8_t data[], uint16_t len);

private:
    typedef enum {
        PS_FIRST_AND_ONLY =     0b0000000000000000,
        PS_FIRST_AND_NOT_LAST = 0b0010000000000000,
        PS_LAST =               0b0100000000000000,
        PS_MIDDLE =             0b0110000000000000
    } PacketStatus_e;
    
    BLEDevice* blePtr;
    UARTService* uartServicePtr;
    PacketStatus_e packetStatus;

    void sendOverBLE(uint16_t cmd, uint8_t data[], uint16_t len, PacketStatus_e status);
};



#endif // __BLE_HELPER_H__