
#include "bleHelper.h"

BLEHelper::BLEHelper(BLEDevice* ble, UARTService* UuartServicePtr)
{
    blePtr = ble;
    uartServicePtr = UuartServicePtr;
}


void BLEHelper::sendOverBLE(uint16_t cmd, uint8_t data[], uint16_t len, PacketStatus_e status)
{
    if(len > 18) {
        // this is a problem since we can only send 20 bytes of payload and need 2 bytes for the command 
        // so total of 18 can be sent in a single BLE transaction.
    }

    uint8_t buf[len + 2];        // should set it to the max single packet size
    uint8_t offset = 0;
    uint16_t tmp = cmd | (uint16_t)status;
    memcpy(buf, &tmp, sizeof(uint16_t));       // command
    offset+=sizeof(uint16_t);
    memcpy(&buf[offset], &data[0], len);              // data
    offset+= len;
    blePtr->updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), buf, offset);
}

void BLEHelper::sendPacketOverBLE(uint16_t cmd, uint8_t data[], uint16_t len)
{
    uint8_t nPackets = (len / 19) + 1;
    uint8_t remainingPackets = nPackets;
    uint16_t offset = 0;
    bool first = true;
    const uint8_t maxDataPayload = 18;   // max is 20 but we are sending a command of 2 bytes always

    do {
        if(nPackets == 1) {
            // first and only
            packetStatus = PS_FIRST_AND_ONLY;
            sendOverBLE(cmd, &data[offset], len, packetStatus);
            remainingPackets = 0;
        } else if(remainingPackets == 1) {
            // last one
            packetStatus = PS_LAST;
            sendOverBLE(cmd, &data[offset], len-offset, packetStatus);
            remainingPackets = 0;
        } else if(remainingPackets > 1 && first == true) {
            // first and more to come
            packetStatus = PS_FIRST_AND_NOT_LAST;
            sendOverBLE(cmd, &data[offset], maxDataPayload, packetStatus);
            offset += maxDataPayload;
            remainingPackets -= 1;
            first = false;
        } else if(remainingPackets > 1 && first == false) {
            // middle
            packetStatus = PS_MIDDLE;
            sendOverBLE(cmd, &data[offset], maxDataPayload, packetStatus);
            offset += maxDataPayload;
            remainingPackets -= 1;
        }

        wait_ms(50);        // 40ms delay seems to be a limit
    } while (remainingPackets > 0);
}

