#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"

#define OFF 0
#define ON 1

Serial pc(USBTX, USBRX);

PwmOut rled(PTE29);
PwmOut gled(PTD5);

MMA8451Q acc(PTE25, PTE24,0x1d<<1);
MAG3110 mag(PTE25, PTE24);
AnalogIn lightSensor(PTE22);
TSISensor tsi;
AnalogIn sinwave(PTB1);

struct
{
  int mag : 1;
  int acc : 1;
  int light : 1;
  int touch : 1;
  int sine : 1;  
} status;

Timer timer_mag;
Timer timer_acc;
Timer timer_light;
Timer timer_touch;
Timer timer_sin;

int threshold1 = 32767;
int threshold2 = 32767;
int threshold3 = 32767;
int threshold4 = 32767;
int threshold5 = 32767;

int START = OFF;

void calXY() //magnetometer calibration: finding max and min of X, Y axis
{
    int tempXmax, tempXmin, tempYmax, tempYmin, newX, newY;

    rled = ON;

    printf("Waiting for initial press\n");
    // Wait for slider to be pressed
    while( tsi.readDistance() == 0 ) {
        rled = ON;
        wait(0.2);
        rled = OFF;
        wait(0.2);
    }

    printf("Waiting for release\n");

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        rled = OFF;
        wait(0.2);
        rled = ON;
        wait(0.2);
    }
    rled = OFF;
    wait(0.5);

    printf("Rotate\n");

    tempXmax = tempXmin = mag.readVal(MAG_OUT_X_MSB);
    tempYmax = tempYmin = mag.readVal(MAG_OUT_Y_MSB);

    while(tsi.readDistance() == 0) {
        gled = ON;
        wait(0.1);
        gled = OFF;
        wait(0.1);
        newX = mag.readVal(MAG_OUT_X_MSB);
        newY = mag.readVal(MAG_OUT_Y_MSB);
        if (newX > tempXmax) tempXmax = newX;
        if (newX < tempXmin) tempXmin = newX;
        if (newY > tempYmax) tempYmax = newY;
        if (newY < tempYmin) tempYmin = newY;
    }
   
    mag.setCalibration( tempXmin, tempXmax, tempYmin, tempYmax );

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        gled = OFF;
        wait(0.2);
        gled = ON;
        wait(0.2);
    }
    gled = OFF;
    wait(1.0);
}
void send4bytes(char label,void* x){
    char *p = (char *)x;
    pc.putc(label);
    pc.putc(*p);
    pc.putc(*(p+1));
    pc.putc(*(p+2));
    pc.putc(*(p+3));
}
void mag_send(){
    int x = 0, y = 0, z = 0;
    float h = mag.getHeading();
    mag.getValues(&x, &y, &z);
    __disable_irq();
    send4bytes(0x00,&x);
    send4bytes(0x01,&y);
    send4bytes(0x02,&z);
    send4bytes(0x03,&h);
    __enable_irq();
}
void accl_send(){
    float x = acc.getAccX();
    float y = acc.getAccY();
    float z = acc.getAccZ();
    __disable_irq();
    send4bytes(0x04,&x);
    send4bytes(0x05,&y);
    send4bytes(0x06,&z);
    __enable_irq();
}

void light_send(){
    float cur_value = lightSensor;
    __disable_irq();
    send4bytes(0x07,&cur_value);
    __enable_irq();
}
 void touch_send(){
    float cur_value = tsi.readPercentage();;
    __disable_irq();
    send4bytes(0x08,&cur_value);
    __enable_irq();
}
void sin_send(){
    float cur_value = sinwave.read();;
    __disable_irq();
    send4bytes(0x09,&cur_value);
    __enable_irq();
}

void configuration(){
    rled = OFF;
    char command = pc.getc();
    command = pc.getc();
    float sr;
    char temp[4];
    if (command == 0x01){ // magnetometer
        status.mag = ON;
        temp[0] = pc.getc();
        temp[1] = pc.getc();
        temp[2] = pc.getc();
        temp[3] = pc.getc();
        sr = *(float*)temp;
        threshold1 =(int) 1/sr *1000;
        timer_mag.reset();
    }
    else{
        status.mag = OFF;
        timer_mag.stop();
    }
    command = pc.getc();
    if (command == 0x01){ // accelerometer
        status.acc = ON;
        temp[0] = pc.getc();
        temp[1] = pc.getc();
        temp[2] = pc.getc();
        temp[3] = pc.getc();
        sr = *(float*)temp;
        threshold2 =(int) 1/sr *1000; 
        timer_acc.reset();                           
    }                     
    else{
        status.acc = OFF;   
        timer_acc.stop();
    }
    command = pc.getc();
    if (command == 0x01){ // light sensor
        status.light = ON;
        temp[0] = pc.getc();
        temp[1] = pc.getc();
        temp[2] = pc.getc();
        temp[3] = pc.getc();
        sr = *(float*)temp;
        threshold3 =(int) 1/sr *1000;  
        timer_light.reset();                          
    }
    else{
        status.light = OFF;
        timer_light.stop();
    }
    command = pc.getc();
    if (command == 0x01){ // touch sensor
        status.touch = ON;
        temp[0] = pc.getc();
        temp[1] = pc.getc();
        temp[2] = pc.getc();
        temp[3] = pc.getc();
        sr = *(float*)temp;
        threshold4 =(int) 1/sr *1000;
        timer_touch.reset();                          
    }
    else{
        status.touch = OFF;
        timer_touch.stop();
    }
    command = pc.getc();
    if (command == 0x01){ // sinewave receiver
        status.sine = ON;
        temp[0] = pc.getc();
        temp[1] = pc.getc();
        temp[2] = pc.getc();
        temp[3] = pc.getc();
        sr = *(float*)temp;
        threshold5 =(int) 1/sr *1000;
        timer_sin.reset();                          
    }
    else{
        status.sine = OFF;
        timer_sin.stop();
    }
    rled = ON;     
    START = ON;            
}

int main(){
    status.mag = 0;
    status.acc = 0;
    status.light = 0;
    status.touch = 0;
    status.sine = 0;
    calXY();
    pc.attach(&configuration);
    while(START == OFF){
        pc.putc(0xFF);    
    }
    pc.putc(0xFE);
    
        
    timer_mag.start();
    timer_acc.start();
    timer_light.start();
    timer_touch.start();
    timer_sin.start();
    while(1) {
        if (status.mag == ON){
            if (timer_mag.read_ms()>threshold1){
                   mag_send(); 
                   timer_mag.reset();
            }
        }
        if (status.acc == ON){
            if (timer_acc.read_ms()>threshold2){
                   accl_send(); 
                   timer_acc.reset();
            }        
        }
        if (status.light == ON){
            if (timer_light.read_ms()>threshold3){
                   light_send(); 
                   timer_light.reset();
            }        
        }
        if (status.touch == ON){
            if (timer_touch.read_ms()>threshold4){
                   touch_send(); 
                   timer_touch.reset();
            }        
        }  
        if (status.sine == ON){
            if (timer_sin.read_ms()>threshold5){
                   sin_send(); 
                   timer_sin.reset();
            }        
        }           
    }
}