
#include "MAG3110.h"
#include "mbed.h"

/******************************************************************************
 * Constructors
 ******************************************************************************/
MAG3110::MAG3110(PinName sda, PinName scl,float dateRate, int overSample): _i2c(sda, scl), 
    _i2c_address(0x0E<<1), _pc(NULL), _debug(false)
{   
    Setdr(dateRate);
    Setosr(overSample); 
    begin();
}

MAG3110::MAG3110(PinName sda, PinName scl): _i2c(sda, scl), 
    _i2c_address(0x0E<<1), _pc(NULL), _debug(false),dr(MAG_3110_SAMPLE80),osr(MAG_3110_OVERSAMPLE2)
{
    begin();
}

MAG3110::MAG3110(PinName sda, PinName scl, Serial *pc): _i2c(sda, scl), 
   _i2c_address(0x0E<<1), _pc(pc), _debug(true),dr(MAG_3110_SAMPLE80),osr(MAG_3110_OVERSAMPLE2)
{
    begin();
}

void MAG3110::begin()
{
    
    char cmd[2];

    cmd[0] = MAG_CTRL_REG2;
    cmd[1] = 0x80;
    _i2c.write(_i2c_address, cmd, 2);

    cmd[0] = MAG_CTRL_REG1;
//    cmd[1] = MAG_3110_SAMPLE80+MAG_3110_OVERSAMPLE2+MAG_3110_ACTIVE;
    cmd[1] = dr+osr+MAG_3110_ACTIVE;
    _i2c.write(_i2c_address, cmd, 2);
    
    // No adjustment initially
    _avgX = 0;
    _avgY = 0;
}

// Read a single byte form 8 bit register, return as int
int MAG3110::readReg(char regAddr)
{
    char cmd[1];

    cmd[0] = regAddr;
    _i2c.write(_i2c_address, cmd, 1);

    cmd[0] = 0x00;
    _i2c.read(_i2c_address, cmd, 1);
    return (int)( cmd[0]);
}


// read a register per, pass first reg value, reading 2 bytes increments register
// Reads MSB first then LSB
int MAG3110::readVal(char regAddr)
{
    char cmd[2];

    cmd[0] = regAddr;
    _i2c.write(_i2c_address, cmd, 1);

    cmd[0] = 0x00;
    cmd[1] = 0x00;
    _i2c.read(_i2c_address, cmd, 2);
    return (int)( (cmd[1]|(cmd[0] << 8))); //concatenate the MSB and LSB
}


float MAG3110::getHeading()
{
    int xVal = readVal(MAG_OUT_X_MSB);
    int yVal = readVal(MAG_OUT_Y_MSB);
    return (atan2((double)(yVal - _avgY),(double)(xVal - _avgX)))*180/PI;
}

void MAG3110::getValues(int *xVal, int *yVal, int *zVal)
{
    *xVal = readVal(MAG_OUT_X_MSB);
    *yVal = readVal(MAG_OUT_Y_MSB);
    *zVal = readVal(MAG_OUT_Z_MSB);
}


void MAG3110::setCalibration(int minX, int maxX, int minY, int maxY )
{
    _avgX=(maxX+minX)/2;
    _avgY=(maxY+minY)/2;
}

void MAG3110::Setdr(float dateRate)
{
        if (dateRate==80)
            dr=MAG_3110_SAMPLE80;
        else if(dateRate==40)
            dr=MAG_3110_SAMPLE40;
        else if(dateRate==20)
            dr=MAG_3110_SAMPLE20;
        else if(dateRate==10)
            dr=MAG_3110_SAMPLE10;
        else if(dateRate==5)
            dr=MAG_3110_SAMPLE5;
        else if(dateRate==2.5)
            dr=MAG_3110_SAMPLE2_5;
        else if(dateRate==1.25)
            dr=MAG_3110_SAMPLE1_25;
        else if(dateRate==0.625)
            dr=MAG_3110_SAMPLE0_625;
        else 
            dr=MAG_3110_SAMPLE80;
}

void MAG3110::Setosr(int overSample)
{
       switch(overSample)
    {
        case 16:osr=MAG_3110_OVERSAMPLE1;break;
        case 32:osr=MAG_3110_OVERSAMPLE2;break;
        case 64:osr=MAG_3110_OVERSAMPLE3;break;
        case 128:osr=MAG_3110_OVERSAMPLE4;break;
        default:osr=MAG_3110_OVERSAMPLE2;break;
    }   
}

void MAG3110::Overwrite_dr_osr(float dateRate,int overSample)
{
    char cmd[2];
    Setdr(dateRate);
    Setosr(overSample);
    cmd[0] = MAG_CTRL_REG1;
    cmd[1] = dr+osr+MAG_3110_ACTIVE;
    _i2c.write(_i2c_address, cmd, 2);
}
