//KL46Z try out
#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include <cstdlib>
#include <iostream>
#define OFF 0;
#define ON 1;

Serial pc(USBTX, USBRX);

TSISensor tsi;
MMA8451Q acc51(PTE25, PTE24, 0x1D<<1);
MAG3110 mag(PTE25, PTE24);

PwmOut rled(PTE29);
PwmOut gled(PTD5);
AnalogIn lightSensor(PTE22);
DigitalIn SW12(PTC3);
DigitalIn SW32(PTC12);
//AnalogOut lcd03(PTB23);
//PwmOut lcd07(PTB7);

void calXY() //magnetometer calibration: finding max and min of X, Y axis
{
    int tempXmax, tempXmin, tempYmax, tempYmin, newX, newY;

    rled = ON;

    printf("Waiting for initial press\n");
    // Wait for slider to be pressed
    while( tsi.readDistance() == 0 ) {
        rled = ON;
        wait(0.2);
        rled = OFF;
        wait(0.2);
    }

    printf("Waiting for release\n");

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        rled = OFF;
        wait(0.2);
        rled = ON;
        wait(0.2);
    }
    rled = OFF;
    wait(0.5);

    printf("Rotate\n");

    tempXmax = tempXmin = mag.readVal(MAG_OUT_X_MSB);
    tempYmax = tempYmin = mag.readVal(MAG_OUT_Y_MSB);

    while(tsi.readDistance() == 0) {
        gled = ON;
        wait(0.1);
        gled = OFF;
        wait(0.1);
        newX = mag.readVal(MAG_OUT_X_MSB);
        newY = mag.readVal(MAG_OUT_Y_MSB);
        if (newX > tempXmax) tempXmax = newX;
        if (newX < tempXmin) tempXmin = newX;
        if (newY > tempYmax) tempYmax = newY;
        if (newY < tempYmin) tempYmin = newY;
    }
   
    mag.setCalibration( tempXmin, tempXmax, tempYmin, tempYmax );

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        gled = OFF;
        wait(0.2);
        gled = ON;
        wait(0.2);
    }
    gled = OFF;
    wait(1.0);
}

int main()
{
    using namespace std;
    
    float onTime = 1.0;
    float offTime = 0.0;
    float holdTime = 3.0;
    bool on = true;
    bool off = false;
    int magX = 0, magY = 0, magZ = 0;
    //lcd03.write(0.33);
    //lcd07.write(0.25);
    //lcd07.period_ms(10);
    pc.baud(9600);
    calXY();
    mag.Overwrite_dr_osr(40,16);
    acc51.Overwrite_dr(200);
    tsi.Overwrite_ps_nscn(5,5);
    while(true) {
                
        rled = onTime - abs(acc51.getAccX());
        gled = onTime - abs(acc51.getAccY());
        mag.getValues(&magX, &magY, &magZ);
        
        cout << "MMA8451: " << acc51.getAccX() << "\t" << acc51.getAccY() << "\t" << acc51.getAccZ() << "\n\r" << endl;
        cout << "MAG3110: " << magX << "\t" << magY << "\t" << magZ << "\n\r" << endl;
        cout << "MAG3110: " << mag.getHeading() << "\n\r" << endl;
        wait(holdTime);
        
        rled = tsi.readPercentage();
        gled = tsi.readPercentage();
        
        cout << "Touch: " << tsi.readPercentage() << "\n\r" << endl;
        cout << "SW12: " << SW12 << "\n\r" << endl;
        cout << "SW32: " << SW32 << "\n\r" << endl;
        cout << "Light Sensor: " << lightSensor << "\n\r" << endl;
        wait(holdTime);
    }
    return 0;
}
