#include "mbed.h"
#define _MBED_
#include "Adafruit_9DOF.h"
#include "Serial_base.h"



/* Assign a unique ID to the sensors */

Adafruit_9DOF                 dof   = Adafruit_9DOF();

Adafruit_LSM303_Accel_Unified accel = Adafruit_LSM303_Accel_Unified(30301);

Adafruit_LSM303_Mag_Unified   mag   = Adafruit_LSM303_Mag_Unified(30302);


/* Update this with the correct SLP for accurate altitude measurements */

float seaLevelPressure = SENSORS_PRESSURE_SEALEVELHPA;


/**************************************************************************
/
/
    @brief  Initialises all the sensors used by this example

/
**************************************************************************/

void initSensors()
{

  if(!accel.begin())
  {
 
   /* There was a problem detecting the LSM303 ... check your connections */
    
    s_com->println(("Ooops, no LSM303 detected ... Check your wiring!"));

    while(1);

  }
  if(!mag.begin())
  {

    /* There was a problem detecting the LSM303 ... check your connections */

    s_com->println("Ooops, no LSM303 detected ... Check your wiring!");

    while(1);

  }

}
/**************************************************************************/



/**************************************************************************/

void setup(void)
{

  

  s_com->println(("Adafruit 9 DOF Pitch/Roll/Heading Example"));
 s_com->println("");

  
  /* Initialise the sensors */

  initSensors();

}


/**************************************************************************
/
/
    @brief  Constantly check the roll/pitch/heading/altitude/temperature

**************************************************************************/

void loop(void)
{

  sensors_event_t accel_event;

  sensors_event_t mag_event;

  sensors_vec_t   orientation;


  /* Calculate pitch and roll from the raw accelerometer data */

  accel.getEvent(&accel_event);

  if (dof.accelGetOrientation(&accel_event, &orientation))
  {

    /* 'orientation' should have valid .roll and .pitch fields */

    s_com->print(("Roll: "));

    s_com->print(orientation.roll);

    s_com->print(("; "));

    s_com->print(("Pitch: "));


    s_com->print(orientation.pitch);

    s_com->print(("; "));

  }

  
  /* Calculate the heading using the magnetometer */

  mag.getEvent(&mag_event);

  if (dof.magGetOrientation(SENSOR_AXIS_Z, &mag_event, &orientation))
  {

    /* 'orientation' should have valid .heading data now */

    s_com->print(("Heading: "));

    s_com->print(orientation.heading);

    s_com->print(("; "));

  }


  s_com->println((""));

  wait(0.1);

}
    
int main()
{
    setup();
    while(1)
        loop();
}