/*
The MIT License (MIT)
 
Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.
 
Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO Animation SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/
 
/**
  * Class definition for a MicroBit BLE Animation Service.
  * Provides a BLE gateway onto an Animation Model.
  */
 
#include "MicroBitConfig.h"
#include "MicroBitAnimationService.h"
#include "ble/UUID.h"
#include "Animator.h"
 
/**
  * Constructor.
  * Create a representation of the AnimationService
  * @param _ble The instance of a BLE device that we're running on.
  */
MicroBitAnimationService::MicroBitAnimationService(BLEDevice &_ble) :
        ble(_ble)
{
    // TODO: Three GattCharacteristic objects. UUID, valuePTR, length, max length, properties.
 
    // TODO: initialise characteristic value buffers
 
    // Set default security requirements - optional
    // animationTypeCharacteristic.requireSecurity(SecurityManager::MICROBIT_BLE_SECURITY_LEVEL);
    // animationStatusCharacteristic.requireSecurity(SecurityManager::MICROBIT_BLE_SECURITY_LEVEL);
    // animationControlCharacteristic.requireSecurity(SecurityManager::MICROBIT_BLE_SECURITY_LEVEL);
 
    // TODO: create GattService containing the three characteristics
    // create an array of our characteristics so we can pass them to the service when we create it

    // create the animation service and specify its characteristics
 
 
    // TODO: add the service to the Bluetooth attribute table
 
    // TODO: take a note of the handles of our new characteristics now that they're in the attribute table

    // TODO: register a callback function for when a characteristic is written to
    
    // subscribe to animation status events so they can be notified to the connected client
    if (EventModel::defaultEventBus)
        EventModel::defaultEventBus->listen(ANIMATION_STATUS_EVENT, MICROBIT_EVT_ANY, this, &MicroBitAnimationService::animationStatusUpdate,  MESSAGE_BUS_LISTENER_IMMEDIATE);
}
 
 
/**
  * Callback. Invoked when any of our attributes are written via BLE.
  */
void MicroBitAnimationService::onDataWritten(const GattWriteCallbackParams *params)
{
    // TODO: handle write to animation type characteristic
    
    // TODO: handle write to animation control characteristic       
}
 
void MicroBitAnimationService::animationStatusUpdate(MicroBitEvent e)
{
    // TODO: notify connected client of change to the animation status characteristic
}
 
const uint8_t  MicroBitAnimationServiceUUID[] = {
    0xe9,0x5d,0x71,0x70,0x25,0x1d,0x47,0x0a,0xa0,0x62,0xfa,0x19,0x22,0xdf,0xa9,0xa8
};
 
const uint8_t  MicroBitAnimationServiceAnimationTypeCharacteristicUUID[] = {
    0xe9,0x5d,0xC3,0x06,0x25,0x1d,0x47,0x0a,0xa0,0x62,0xfa,0x19,0x22,0xdf,0xa9,0xa8
};
 
const uint8_t  MicroBitAnimationServiceAnimationStatusCharacteristicUUID[] = {
    0xe9,0x5d,0x45,0x92,0x25,0x1d,0x47,0x0a,0xa0,0x62,0xfa,0x19,0x22,0xdf,0xa9,0xa8
};
 
const uint8_t  MicroBitAnimationServiceAnimationControlCharacteristicUUID[] = {
    0xe9,0x5d,0xb8,0x4c,0x25,0x1d,0x47,0x0a,0xa0,0x62,0xfa,0x19,0x22,0xdf,0xa9,0xa8
};
 