/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO Animation SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#ifndef MICROBIT_ANIMATION_SERVICE_H
#define MICROBIT_ANIMATION_SERVICE_H

#include "MicroBitConfig.h"
#include "Animator.h"
#include "ble/BLE.h"

// UUIDs for our service and characteristics
extern const uint8_t  MicroBitAnimationServiceUUID[];
// animation type: indicates the type of animation that should be executed by the microbit            : R|W
extern const uint8_t  MicroBitAnimationServiceAnimationTypeCharacteristicUUID[];
// animation status: indicates whether or not an animation is currently in progress                   : R|N
extern const uint8_t  MicroBitAnimationServiceAnimationStatusCharacteristicUUID[];
// animation control: allows various types of control to be exercised (start|stop|faster|slower)      : W
extern const uint8_t  MicroBitAnimationServiceAnimationControlCharacteristicUUID[];

/**
  * Class definition for a MicroBit BLE Animation Service.
  */
class MicroBitAnimationService
{
    public:

    /**
      * Constructor.
      * Create a representation of the AnimationService
      * @param _ble The instance of a BLE device that we're running on.
      */
    MicroBitAnimationService(BLEDevice &_ble);

    /**
      * Callback. Invoked when a characteristic is written to
      */
    void onDataWritten(const GattWriteCallbackParams *params);
    
    private:

    // Bluetooth stack we're running on.
    BLEDevice           &ble;
    
    
    // TODO: memory for our Animation characteristics.



    // TODO: handles on this service's characterisitics.
    
    
    
    void animationStatusUpdate(MicroBitEvent e);

};

#endif
