/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO Animation SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#ifndef ANIMATOR_H
#define ANIMATOR_H

/*
 * Class definition for an Animator
 */
 
#include "MicroBitDisplay.h"

#define NUMBER_OF_ANIMATIONS 0x03

#define ANIMATION_CONTROL_EVENT 9100
#define ANIMATION_CONTROL_START 0x01
#define ANIMATION_CONTROL_STOP  0x02

#define ANIMATION_TYPE_EVENT    9101
#define ANIMATION_TYPE_FLASH    0x01
#define ANIMATION_TYPE_RIPPLE   0x02
#define ANIMATION_TYPE_SPIRAL   0x03

#define ANIMATION_STATUS_EVENT  9101
#define ANIMATION_STATUS_FREE   0x00
#define ANIMATION_STATUS_BUSY   0x01

class Animator
{

    public:
        
    int playing;
    int current_animation;
    int sleep_time;

    Animator(MicroBitDisplay &_display);

    void setAnimationType(uint16_t animation);

    void start();
    
    void stop();
    
    void faster();
    
    void slower();
    
    void ripple();
    
    void spiral();
    
    void flash();
    
    void animationLoop();
    
    private:
    
    MicroBitDisplay     &display;
       
};

#endif