/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO Animation SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

// 8th March 2017

#include "MicroBit.h"
#include "Animator.h"
#include <math.h>

MicroBit uBit;

void onConnected(MicroBitEvent) 
{ 
    uBit.display.print("C"); 
} 
 
void onDisconnected(MicroBitEvent) 
{ 
    uBit.display.print("D"); 
} 
 
int main() 
{ 
    // Initialise the micro:bit runtime. 
    uBit.init(); 
 
    uBit.display.print("X"); 
 
    uBit.messageBus.listen(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_CONNECTED, onConnected); 
    uBit.messageBus.listen(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_DISCONNECTED, onDisconnected); 
 
    // services: note that the device information service is included by default 
    // see config.json property microbit-dal.bluetooth. device_info_service 
 
    new MicroBitAccelerometerService(*uBit.ble, uBit.accelerometer); 
    new MicroBitLEDService(*uBit.ble, uBit.display); 
    new MicroBitTemperatureService(*uBit.ble, uBit.thermometer);
 
    release_fiber(); 
}
