#include "MicroBit.h"

MicroBit uBit;

Serial pcCom(USBTX, USBRX);

// TODO: global data and functions
char URL[] = "https://www.bluetooth.com";

// lvl : Pwr@ 1m : Pwr@ 0m
//  0  :   -90   :   -49
//  1  :   -78   :   -37
//  2  :   -74   :   -33
//  3  :   -69   :   -28 
//  4  :   -66   :   -25 
//  5  :   -61   :   -20 
//  6  :   -56   :   -15 
//  7  :   -51   :   -10

const int8_t CALIBRATED_POWERS[] = {-49, -37, -33, -28, -25, -20, -15, -10};

uint8_t advertising = 0;
uint8_t tx_power_level = 6;

BLE_BEACON_TYPE beacon_type = BEACON_TYPE_EDDYSTONE; // BEACON_TYPE_EDDYSTONE, BEACON_TYPE_IBEACON, BEACON_TYPE_NONE
// proximity UUID MSB first
const uint8_t  iBeaconProximityUUIDraw[] = {
    0x01, 0xD9, 0xC8, 0x00, 0x45, 0xF3, 0x40, 0x24, 0x93, 0xB0, 0xB0, 0xCD, 0x4A, 0x50, 0x2A, 0xF7
}; // 01D9C800-45F3-4024-93B0-B0CD4A502AF7 use this UUID including dashes in mobile application
const UUID iBeaconProximityUUID(iBeaconProximityUUIDraw);
const int16_t iBeaconMajor = 1234;
const int16_t iBeaconMinor = 5678;

void startAdvertising() {
    switch(beacon_type)
    {
        case BEACON_TYPE_EDDYSTONE:
            uBit.bleManager.advertiseEddystoneUrl(URL, CALIBRATED_POWERS[tx_power_level-1], false);
            uBit.display.scroll("ADV Eddystone");
            break;
        case BEACON_TYPE_IBEACON:
            uBit.bleManager.advertiseIBeacon(iBeaconProximityUUID, iBeaconMajor, iBeaconMinor, CALIBRATED_POWERS[tx_power_level-1]);
            uBit.display.scroll("ADV iBeacon");
            break;
        case BEACON_TYPE_NONE:
        default:
            break;
    }
    uBit.bleManager.setTransmitPower(tx_power_level);
    advertising = 1;
}

void stopAdvertising() {
    uBit.bleManager.stopAdvertising();
    uBit.display.scroll("OFF");
    advertising = 0;
}

void onButtonA(MicroBitEvent)
{
    // toggle advertising
    switch(advertising)
    {
        case 0:
            startAdvertising();
            break;
        case 1:
            stopAdvertising();
            break;
        default:
            break;
    }
}

void onButtonB(MicroBitEvent)
{
    // toggle advertising type
    stopAdvertising();
    switch(beacon_type)
    {
        case BEACON_TYPE_EDDYSTONE:
            beacon_type = BEACON_TYPE_IBEACON;
            break;
        case BEACON_TYPE_IBEACON:
            beacon_type = BEACON_TYPE_EDDYSTONE;
            break;
        case BEACON_TYPE_NONE:
        default:
            beacon_type = BEACON_TYPE_EDDYSTONE;
            break;
   }
   startAdvertising();
}



int main()
{
    pcCom.printf("mBit Beacon.\n\r");

    // TODO: main processing code    
    // Initialize the micro:bit runtime.
    uBit.init();

    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onButtonA);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_CLICK, onButtonB);
    
    uBit.bleManager.advertise();  //First Advertisment, adv name only
    
    release_fiber();
}
