#include "mbed.h"
#include "EthernetInterface.h"
#include "netCfg.h"
#include <string>
#include "SDFileSystem.h"
#include "NTPClient.h"
#include <vector>
#include <fstream>
#include "TFT_4DGL.h"


struct Event {
    struct tm start;
    string title;
    string location;
    bool valid;
};

EthernetInterface eth;

RawSerial pc(USBTX, USBRX);

TFT_4DGL ecran(p9,p10,p11);

vector<Event> week[7];
//DigitalOut led1(LED1);

time_t ctTime;

 // serial tx, serial rx, reset pin;

string timeToString(struct tm *today) {
    string stringToReturn = "Hello, Josh. It's ";
    const string days[7] =   {"Sunday, ", "Monday, ", "Tuesday, ", "Wednesday, ",
                        "Thursday, ", "Friday, ", "Saturday, "};
    const string months[12] =    {"January ", "February ", "March ", "April ", "May ",
                            "June ", "July ", "August ", "September ", "October ",
                            "November ", "December "};
  //  char lastBit[15];
    //sprintf(lastBit, "%d, %d. %02d:%02d UTC", today->tm_mday, today->tm_year+1900, today->tm_hour, today->tm_min);
    //stringToReturn += days[today->tm_wday] + months[today->tm_mon] + lastBit;
    char lastBit[5];
    sprintf(lastBit, "%d, %d.", today->tm_mday, today->tm_year+1900);
    stringToReturn += days[today->tm_wday] + months[today->tm_mon] + lastBit;
    return stringToReturn;
}

void display() {
    {
    struct tm *today;
    {
    time_t     now;
    

    /* Get the current time */
    now = time(NULL);
        today = localtime(&now);
    /* Format and print the time, "ddd yyyy-mm-dd hh:mm:ss zzz" */
       //hello user <GOOD MORNING/AFTERNOON/EVENING DEPENDING ON TIME>
    char *cstr = &timeToString(today)[0u];
    ecran.text_string(cstr, 3, 1, FONT_12X16, WHITE);
    }
    char lastBit[10];
    sprintf(lastBit, "%02d:%02d UTC", today->tm_hour, today->tm_min);
    ecran.text_string(lastBit, 3, 3, FONT_12X16, WHITE);
    {char date[2];
    for (int i = 0; i < 7; i++) {
        sprintf(date, "%d", today->tm_mday+i);
       // sprintf(date, "%d", 1+i);
        ecran.text_string(date, 22 + (i*8), 11, FONT_8X8, WHITE);
    }}
    }
    {
    //your week
    ecran.text_string("Your Week", 43, 7, FONT_8X8, WHITE);
    //make calendar lines
    for (int i = 0; i < 8; i++) {
        ecran.line(170+(64*i), 80, 170+(64*i), 245, WHITE);
    }
    for (int i = 0; i < 2; i ++) {
        ecran.line(170, 80+(i*165), 618, 80+(i*165), WHITE);
    }}
    {
        
    for(int i = 0; i < 7; i++) {
        //pc.printf("i%d\n", i);
        int size = week[i].size();
        for (int j = 0; j < size; j++) {
           pc.printf("j%d\n", j);
           // pc.printf("%d\n", week[i].size());
            //pc.printf("Start: %s\n", asctime(&week[i][j].start));
            {
            char str[5];
            sprintf(str, "%02d:%02d", week[i][j].start.tm_hour, week[i][j].start.tm_min);
            ecran.text_string(str, 29 + (13*i), 13 + (4*j), FONT_5X7, WHITE);}
            ecran.text_string(&week[i][j].title[0u], 29 + (13*i), 14 + (4*j), FONT_5X7, WHITE);

            //if(!week[i][j].location.empty())
              //  ecran.text_string(&week[i][j].location[0u], 29 + (13*i), 15 + (4*j), FONT_5X7, WHITE);
           // pc.printf("Title: %s\n", week[i][j].title);
            //pc.printf("Location: %s\n", week[i][j].location);
        }
    }}
    /*
    //sunny
    
    ecran.circle(90, 110, 30, 0xFFFF00);
    //cloudy
    ecran.circle(90, 110, 20, 0xFFFF00);
    ecran.circle(80, 138, 20, DGREY);
    ecran.circle(98, 130, 20, DGREY);
    ecran.circle(105, 138, 20, DGREY);
    //stormy
    */
}

int comparTime1(struct tm *t1, struct tm *t2) {
    int diff;

    if ((diff = t1->tm_year - t2->tm_year) != 0) {
    return diff;
    }
    if ((diff = t1->tm_mon - t2->tm_mon) != 0) {
    return diff;
    }
    if ((diff = t1->tm_mday - t2->tm_mday) != 0) {
    return diff;
    }
    if ((diff = t1->tm_hour - t2->tm_hour) != 0) {
    return diff;
    }
    if ((diff = t1->tm_min - t2->tm_min) != 0) {
    return diff;
    }
    if ((diff = t1->tm_sec - t2->tm_sec) != 0) {
    return diff;
    }
    return 0;
}
/*
parseWeather2(int index, string str, string target) {
    index = str.find
}*/

float parseWeather(string &strToParse) {
    //int index = parseWeather2(strToParse.find("description") +14, strToParse);
    int descLoc = strToParse.find("description") + 14;
    string description = strToParse.substr(descLoc);
    descLoc = description.find(",");
    description = description.substr(0, descLoc-1);
   // pc.printf("Description: %s\n", description);
    descLoc = strToParse.find("temp") + 6;
    string temp = strToParse.substr(descLoc);
    descLoc = temp.find(",");
    temp = temp.substr(0, descLoc);
    //pc.printf("temperature: %s\n", temp);
    float tempInF;
    sscanf(temp.c_str(), "%f", &tempInF);
    tempInF = (tempInF * 9.0/5.0) - 459.67;
 //   pc.printf("temp in F: %f", tempInF);
    strToParse = description;
    return tempInF;
}

void getICS() {
   // pc.printf("gettingICS");
    string strToParse = "";
    {TCPSocketConnection sock;
    sock.connect("api.openweathermap.org", 80);
    
    char http_cmd[] = "GET /data/2.5/weather?id=4180439&APPID=24bfe564383f38d5f100c648eac94f09 HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    {char buffer[600];
    
    int ret;
   //while (true) {
        {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret > 0){
            
        buffer[ret] = '\0';
       //printf("Received %d chars from server:\n%s\n", ret, buffer);
        strToParse+=buffer;
        }
        }
        
    //}
    }
    sock.close();}/*
    //pc.printf("Socket Closed");
    float temp = parseWeather(strToParse);
  //  pc.printf("2");
    strToParse = "Current Weather: " + strToParse;
    ecran.text_string("Your Forecast", 5, 7, FONT_8X8, WHITE);
    ecran.text_string(&strToParse[0u], 2, 9, FONT_5X7, WHITE);
    char str[4];
    sprintf(str, "%2.1f", temp);
    strToParse = "Current Temperature: ";
    strToParse.append(str);
    ecran.text_string(&strToParse[0u], 2, 11, FONT_5X7, WHITE);*/
    {
    float temp = parseWeather(strToParse);
    ecran.text_string("Current Weather:", 6, 13, FONT_5X7, WHITE);
    ecran.text_string(&strToParse[0u], 6, 15, FONT_5X7, WHITE);
    ecran.text_string("Your Forecast", 5, 10, FONT_8X8, WHITE);
    char str[6];
    sprintf(str, "%2.1f F", temp);
    ecran.text_string("Current Temperature:", 6, 17, FONT_5X7, WHITE);
    ecran.text_string(str, 6, 19, FONT_5X7, WHITE);}
}

void dumpEvents() {
    pc.printf("dump events\n");
    for(int i = 0; i < 7; i++) {
        for (int j = 0; j < week[i].size(); j++) {
            pc.printf("%02d:%02d", week[i][j].start.tm_hour, week[i][j].start.tm_min);
            
            pc.printf("Title: %s\n", week[i][j].title);
            //pc.printf("Location: %s\n", week[i][j].location);
        }
    }
}

void getEvents() {
    SDFileSystem sd(p5, p6, p7, p8, "sd");
    struct tm* ct;
    struct tm ct1;
    time_t ltrTime;
    ltrTime = time(NULL);
    ct1 = *localtime(&ltrTime);
    ltrTime = ltrTime - (ct1.tm_sec+ct1.tm_min*60 +ct1.tm_hour*60*60) + 60*60*24*7;
    ct1 = *localtime(&ltrTime);
    ctTime = time(NULL);
    ct = localtime(&ctTime);
    ctTime = ctTime - (ct->tm_sec+ct->tm_min*60 +ct->tm_hour*60*60);
    ct = localtime(&ctTime);
    
   // printf("Getting Events\n");
    struct Event created;
    created.valid = false;
    string name, value, extra;
    int temp;
    ifstream ics("/sd/mydir/test.ics");
    //pc.printf("Opened filestream\n");
    size_t pos;
    //pc.printf("Clearing Previous Weeks\n");
    for (int i = 0; i < 7; i++) {
        for (int j = 0; j < week[i].size(); j++) {
            week[i].pop_back();
        }
    }
  //  int i = 0;
    for (string line; getline(ics, line); ) {
       // i++;
       // pc.printf("Parsing line %d: %s\n", i, line);
        {if (line.find("DTSTART")!= string::npos) {
            pos = line.find_first_of(':');
            value = line.substr(pos+1, -1);
            extra = value.substr(0, 4);
            sscanf(extra.c_str(), "%d", &temp);
            created.start.tm_year = temp - 1900;
            //printf("%d\n", temp-1900);
            extra = value.substr(4, 2);
            sscanf(extra.c_str(), "%d", &temp);
            created.start.tm_mon = temp - 1;
            //printf("%d\n", temp-1);
            extra = value.substr(6, 2);
            sscanf(extra.c_str(), "%d", &temp);
            created.start.tm_mday = temp;
            //printf("%d\n", temp);
            extra = value.substr(9, 2);
            sscanf(extra.c_str(), "%d", &temp);
            created.start.tm_hour = temp;
            //printf("%d\n", temp);
            extra = value.substr(11, 2);
            sscanf(extra.c_str(), "%d", &temp);
            created.start.tm_min = temp;
            //printf("%d\n", temp);
            extra = value.substr(13, 2);
            sscanf(extra.c_str(), "%d", &temp);
            created.start.tm_sec = temp;
            //printf("%d\n", temp);
            //pc.printf("test point\n");
            //printf("%d %d %d %d %d %d\n",ct->tm_year,ct->tm_mon,ct->tm_mday,ct->tm_hour, ct->tm_min, ct->tm_sec);
            //printf("%d %d %d %d %d %d\n",ct1.tm_year,ct1.tm_mon,ct1.tm_mday,ct1.tm_hour, ct1.tm_min, ct1.tm_sec);
            int c = comparTime1(&(created.start), ct);
            int d = comparTime1(&(created.start), &ct1);
            //pc.printf("%d    %d\n", c, d);
            if (c > 0 && d < 0) {
                //c.printf("test point\n");
                created.valid = true;
            }
        }}
        
        if (line.find("LOCATION")!= string::npos) {
            pos = line.find_first_of(':');
            value = line.substr(pos + 1, -1);
            created.location = value;
        }
        
        {if (line.find("SUMMARY")!= string::npos) {
            pos = line.find_first_of(':');
            value = line.substr(pos + 1, -1);
            created.title = value;
            if (created.valid) {
                int day = created.start.tm_mday - ct->tm_mday;
                //pc.printf("Day: %d\n", day);
                //pc.printf("vecSize: %d\n", week[day].size());
                int size = week[day].size();
                for (int i = 0; i < size; i++) {
                    //pc.printf("%d\n", i);
                    if (comparTime1(&(week[day][i].start), &(created.start)) > 0) {
                        //pc.printf("%d\n", i);
                        week[day].insert(week[day].begin() + i, created);
                        //pc.printf("Title: %s\n", week[day][i].title);
                        //pc.printf("Location: %s\n", week[day][i].location);
                        //pc.printf("%d\n", i);
                    } else if (i == (week[day].size() - 1)) {
                        //pc.printf("%d\n", i);
                        week[day].insert(week[day].end(), created);
                    }
                }
                if (size == 0) {
                    week[day].insert(week[day].begin(), created);
                    //pc.printf("Day: %d\n\n", day);
                    //pc.printf("Title: %s\n\n", week[day][0].title);
                    //pc.printf("Location: %s\n\n", week[day][0].location);
                }
            
            created.valid = false;
                created.location = "";
      //      } else {
        //        created.valid = false;
          //     created.location = "";
            }
        }}
    }
    pc.printf("done parsing\n");
    ics.close();
    wait(1);
}

void getNTP() {
    NTPClient ntp;
    const char* domain_name = "pool.ntp.org";
    const int port_number = 123;
    //ctTime = time(NULL);
    //printf("Current time is (UTC): %d %s\n", ctTime, ctime(&ctTime));
    //printf("NTP setTime...\n");
   // printf("Result : %d\n", ntp.setTime(domain_name, port_number));
    ntp.setTime(domain_name, port_number);
    ctTime = time(NULL);
    //printf("Time is now (UTC): %d %s\n", ctTime, ctime(&ctTime));
}


int main() {
    eth.init();
    eth.connect();
    {pc.baud(115200);
    //printf("Connected OK\n");
    //printf("IP Address is %s\n", eth.getIPAddress());
    //printf("MAC Address is %s\n", eth.getMACAddress());
    //mkdir("/sd/mydir", 0777);
    }
    
    
    getNTP();
    getEvents();
    //dumpEvents();
    //TFT_4DGL ecran(p9,p10,p11);
    ecran.baudrate(115200);
    ecran.display_control(0x0c, 0x01);
    ecran.background_color(BLACK);
    getICS();
    display();
    
    pc.printf("starting Polls\n");
   // wait(3);
    Timer pollEvents;
    pollEvents.start();
    Timer pollNTP;
    pollNTP.start();
    Timer updateTime;
    updateTime.start();
    //printf("Polling");
    
    while (true) {
        if (updateTime.read() > 60) {
           //printf("updating time\n");
           display();
           updateTime.reset();
        }
        if (pollEvents.read() > 300) {
            getEvents();
            //dumpEvents();
            getICS();
            pollEvents.reset();
            display();
        }
        if (pollNTP.read() > 21000) {
            getNTP();
            pollNTP.reset();
        }
    }
}
