#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "Motor.h"

RawSerial blue(p28,p27);
AnalogIn sensor(p15);
Motor mRight(p26, p23, p24);
Motor mLeft(p25, p21, p22);
uLCD_4DGL uLCD(p9,p10,p11);
BusOut myled(LED1,LED2,LED3,LED4);

Thread bt;
Mutex bt_mutex;

void bluetooth() {
    float velocity = .5;
    char bnum=0;
    char bhit=0;
    while (1) {
        bt_mutex.lock();
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    bt_mutex.unlock();
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                velocity = .25;
                            } else {
                                //add release code here
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                velocity = .5;
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                velocity = .75;
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                velocity = 1.0;
                            } else {
                                //add release code here
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                mLeft.speed(velocity);
                                mRight.speed(velocity);
                            } else {
                                mLeft.speed(0);
                                mRight.speed(0);
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                mLeft.speed(velocity * -1.0);
                                mRight.speed(velocity * -1.0);
                            } else {
                                mLeft.speed(0);
                                mRight.speed(0);
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                mLeft.speed(velocity * -1.0);
                                mRight.speed(velocity);
                            } else {
                                mLeft.speed(0);
                                mRight.speed(0);
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                mLeft.speed(velocity);
                                mRight.speed(velocity * -1.0);
                            } else {
                                mLeft.speed(0);
                                mRight.speed(0);
                            }
                            break;
                        default:
                            break;
                    }
                } else {
                    bt_mutex.unlock();
                }
            } else {
                bt_mutex.unlock();
            }
        } else {
            bt_mutex.unlock();
        }
    }
}
    
int main() {
    bt.start(bluetooth);
    
    float rawDistance;
    float cent;
    
    uLCD.cls();
    wait(1);
    
    while (1) {
        rawDistance = sensor;
        rawDistance = 1-rawDistance;
        cent = rawDistance*(-.155);
        cent = cent +.1542;
        cent = 1/cent;
        bt_mutex.lock();
        uLCD.locate(1,0);
        uLCD.printf("        ");
        uLCD.locate(0,0);
        uLCD.printf("Dist: %2.2f cm\n", cent);
        bt_mutex.unlock(); 
    }
}
