#include "Lib_DFPlayerMini.h"

// constructor
DFPlayerMini::DFPlayerMini( PinName busy, PinName tx, PinName rx ) : _busy(busy), _serial( tx, rx ){
    _func = NULL;
    return;
}

// destructor
DFPlayerMini::~DFPlayerMini(){
    return;    
}

// begin
void DFPlayerMini::begin(){
    _busy.mode( PullUp );    
    _serial.baud(9600);
    _serial.format( 8, RawSerial::None, 1 );
    return;   
}

// attach busy interrupt
void DFPlayerMini::attachBusyInterrupt( BUSYFUNCPTR func ){
    _func   =   func;
    if( _func != NULL ){
        _busy.fall( _func );
    }
    return;
}

// play next track
void DFPlayerMini::playNext(){
    _send_command( DFPLAYER_NEXT, 0x00, 0x00 );
    return;
}

// play previous track
void DFPlayerMini::playPrev(){
    _send_command( DFPLAYER_PREV, 0x00, 0x00 );
    return;
}

// play previous track
void DFPlayerMini::playNumber( uint16_t num ){
    _send_command( 
        DFPLAYER_NUM, 
        (uint8_t)( ( num >> 8 ) & 0xFF ), 
        (uint8_t)( ( num >> 0 ) & 0xFF ) 
    );
    return;
}

// play previous track
void DFPlayerMini::playFolder( uint8_t folder, uint8_t num ){
    _send_command( DFPLAYER_PLAYBACKFOLDER, folder, num );
    return;
}

// increase volume
void DFPlayerMini::volumePlus(){
    _send_command( DFPLAYER_VOL_PLUS, 0x00, 0x00 ); 
    return;
}

// decrease volume
void DFPlayerMini::volumeMinus(){
    _send_command( DFPLAYER_VOL_MINUS, 0x00, 0x00 );    
    return;
}

// set volume
void DFPlayerMini::volumeSet( uint8_t vol ){
    vol = ( vol > 30 ) ? 30 : vol ;
    _send_command( DFPLAYER_VOL_SET, 0x00, vol );
    return;
}

// send command
void DFPlayerMini::_send_command( DFPLAYERMINICOM com, uint8_t param1, uint8_t param2 ){
    uint8_t buf[8];
    
    buf[0]  =   DFPLAYER_STX;
    buf[1]  =   DFPLAYER_VER;
    buf[2]  =   0x06;
    buf[3]  =   com;
    buf[4]  =   0x00;
    buf[5]  =   param1;
    buf[6]  =   param2;
    buf[7]  =   DFPLAYER_ETX;
    
    _serial.write( buf, 8 );

    return;    
}