#ifndef __FILTER_FUNCTIONS_H__
#define __FILTER_FUNCTIONS_H__

#include <math.h>
#include "mbed.h"

typedef enum _BIQUADTYPE{
    FILTER_LPF  =   1,
    FILTER_HPF  =   2,
    FILTER_BPF  =   3,
    FILTER_NF   =   4   
} BIQUADTYPE;

typedef struct _STCOMPFILTER{
    float   _int;
    float   _adj;
    float   _adj_temp;
    float   _param;
} STCOMPFILTER;

typedef struct _STBIQUADFILTER{
    float   in[2];      // input
    float   out[2];     // output
    float   a[3];       // coefficient A
    float   b[3];       // coefficient B
} STBIQUADFILTER;

// complimentary filter
void init_comp_filter( STCOMPFILTER* filter, float param );
void proc_comp_filter( STCOMPFILTER* filter, float dt, float angle_raw, float angle_vec_raw, float* angle, float* angle_vec );

// BiQuad filter
void  init_biquad_filter( STBIQUADFILTER* filter, float freq_sample, float freq, float param, BIQUADTYPE filter_pattern );
float proc_biquad_filter( STBIQUADFILTER* filter, float input );

#endif