#ifndef __DEFINES_H__
#define __DEFINES_H__

#include "mbed.h"
#include "AsyncSerial.hpp"

#include "Lib_DFPlayerMini.h"
#include "Lib_MPU9250.h"
#include "filter_func.h"

// compile option
//#define USE_SERIAL_DEBUG
#define USE_LED_DEBUG
#define USE_FILESYSTEM
#define USE_FIRST_IMU
#define USE_SECOND_IMU
#define USE_MOTOR_CONTROL
#define USE_STEER_CONTROL

#ifdef USE_SERIAL_DEBUG
    #define DEBUG_BAUDRATE  115200
    AsyncSerial  usb_serial( USBTX, USBRX );
#endif

#ifdef USE_LED_DEBUG
    DigitalOut myled[4] =   { LED1, LED2, LED3, LED4 };
#endif

#define PROCESS_INTERVAL_SEC    (0.01f)

#define CAN_RX                  (p30)
#define CAN_TX                  (p29)

#define MPU9250_CS              (p7)
#define MPU9250_MOSI            (p11)
#define MPU9250_MISO            (p12)
#define MPU9250_SCK             (p13)
#define MPU9250_INT             (p8)

#define MPU9250_SDA             (p9)
#define MPU9250_SCL             (p10)

#define DFPLAYER_RX             (p27)
#define DFPLAYER_TX             (p28)
#define DFPLAYER_BUSY           (p18)

#define NEOPIXEL_DOUT           (p21)

#define DEVID_LEFT              (0x01)
#define DEVID_RIGHT             (0x04)

typedef struct _STRUCTSENSOR{
    float acc[3];
    float gyro[3];
    float mag[3];
} STRUCTSENSOR;

typedef struct _STRUCTPOSTURE{
    float angle;
    float angle_vel;
    float wheel[2];
    float wheel_vec[2];
} STRUCTPOSTURE;

typedef struct _STRUCTCONRTOLPARAM{
    float   K_angle;
    float   K_angle_vel;
    float   K_wheel;
    float   K_wheel_vel;
    float   K_rot_vel;
    float   K_trans_vel;
    float   C_max_angle;
    float   C_offset_angle;
} STRUCTCONRTOLPARAM;

typedef struct _STRUCTGAMEPAD{
    float x_raw;
    float y_raw;
    float x_filtered;
    float y_filtered;
    float C_dead_angle;
    float C_max_angle;
} STRUCTGAMEPAD;

extern STRUCTSENSOR         sensor_vehicle;
extern STRUCTSENSOR         sensor_interface;
extern STRUCTPOSTURE        posture;
extern STRUCTCONRTOLPARAM   control;
extern STRUCTGAMEPAD        pad;


//extern Ticker           tic_sen_ctrl;
//extern CAN              can_driver;
//extern MPU9250          imu;
//extern DFPlayerMini     player;

#endif