#include "mbed.h"
#include "FXOS8700.h"
#include "FXAS21002.h"
#include "Hexi_OLED_SSD1351.h"
#include "images.h"
#include "string.h"
#include "ESP8266Interface.h"

// Pin connections
DigitalOut led1(LED_GREEN); // RGB LED
DigitalOut led2(PTA12); // RGB LED

AnalogIn   ain(PTB6);
DigitalOut PWD(PTB2);
DigitalOut G15(PTB11);

// Storage for the data from the sensor
float gyro_data[3];  float gyro_rms=0.0;


Serial pc(USBTX, USBRX); // Serial interface
//RawSerial wifi(PTD3, PTD2);
FXOS8700 mag(PTC11, PTC10);
FXOS8700 accel(PTC11, PTC10);
//FXAS21002 gyro(PTC11,PTC10); werkt nog niet


SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); // SSD1351 OLED Driver (MOSI,SCLK,POWER,CS,RST,DC)

// Variables
float mag_data[3]; // Storage for the data from the sensor
float mag_rms=0.0; // RMS value from the sensor

float accel_data[3]; float accel_rms=0.0;

float mx, my, mz; // Integer value from the sensor to be displayed
const uint8_t *image1; // Pointer for the image to be displayed
char text1[20]; // Text Buffer for dynamic value displayed
char text2[20]; // Text Buffer for dynamic value displayed
char text3[20]; // Text Buffer for dynamic value displayed
int steps;

//void Rx_interrupt();
//void read_line();


// Circular buffers for serial TX and RX data - used by interrupt routines
const int buffer_size = 255;
// might need to increase buffer size for high baud rates
char rx_buffer[buffer_size+1];
// Circular buffer pointers
// volatile makes read-modify-write atomic 
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];

//ESP8266Interface wifi(PTD3,PTD2,PTD11,"QBMT","zoranetwerk",9600); // TX,RX,Reset,SSID,Password,Baud

int main() {
    
     steps = 0;
    /* wifi3 board reset etc */
//    PWD = 1;
//    G15 = 0;     

//    printf("test");
    //ebsocket ws("ws://192.168.1.20:8888/ws");

     
    accel.accel_config();
     
    // Configure Accelerometer FXOS8700, Magnetometer FXOS8700
    mag.mag_config();
    
    /* Setting pointer location of the 96 by 96 pixel bitmap */
    image1  = Magneto;

    /* Turn on the backlight of the OLED Display */
//    oled.DimScreenON();
    
    /* Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0 */
    //oled.DrawImage(image1,0,0);  

    /*Wifi initialisation commands */
    
 //   wifi.init(); //Reset
 //   printf("init done");
 //   wifi.connect(); 
 //   wifi.getIPAddress();





    
    while (true) 
    {
      //gyro.acquire_gyro_data_dps(gyro_data);
      //gyro_rms = sqrt(((gyro_data[0]*gyro_data[0])+(gyro_data[1]*gyro_data[1])+(gyro_data[2]*gyro_data[2]))/3);      
      
      //pc.printf("gyro: %d",gyro_data[0]);
      //pc.printf("gyro: %d",gyro_data[1]);
      //pc.printf("gyro: %d",gyro_data[2]);
      
      accel.acquire_accel_data_g(accel_data);
      accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
      printf("Accelerometer \tX-Axis %4.2f \tY-Axis %4.2f \tZ-Axis %4.2f \tRMS %4.2f\n\r",accel_data[0],accel_data[1],accel_data[2],accel_rms);
      wait(0.2);    
      if ( accel_data[0] > 1 )
       {
         steps++;   
        }   
      
      
      mag.acquire_mag_data_uT(mag_data);
      mag_rms = sqrt(((mag_data[0]*mag_data[0])+(mag_data[1]*mag_data[1])+(mag_data[2]*mag_data[2]))/3);
      //printf("normalized: 0x%04X \n", ain.read_u16());
      //printf("Magnetometer \tX-Axis %4.2f \tY-Axis %4.2f \tZ-Axis %4.2f \tRMS %4.2f adc %d \n\n\r",mag_data[0],mag_data[1],mag_data[2],mag_rms,ain.read_u16());
      wait(0.2);
      mx = mag_data[0];
      my = mag_data[1];
      mz = mag_data[2];

      /* Get OLED Class Default Text Properties */
      oled_text_properties_t textProperties = {0};
      oled.GetTextProperties(&textProperties); 
      
      /* Set text properties to white and right aligned for the dynamic text */
      textProperties.fontColor = COLOR_BLUE;
      textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
      oled.SetTextProperties(&textProperties);  

      strcpy((char *) text1,"QBMT");
      oled.Label((uint8_t *)text1,35,0);   

      /* Display Legends */
      
      textProperties.fontColor = COLOR_WHITE;
      strcpy((char *) text1,"STEPS:");
      oled.Label((uint8_t *)text1,3,15);      
      
      /* Format the value */
      sprintf(text1,"%d",steps);
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
      oled.TextBox((uint8_t *)text1,60,15,20,15); //Increase textbox for more digits
 
 
      
      /* Display Legends */
      strcpy((char *) text1,"Pressure:");
      oled.Label((uint8_t *)text1,3,32);      
      
      /* Format the value */
      sprintf(text1,"%d",ain.read_u16());
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
      oled.TextBox((uint8_t *)text1,65,32,20,15); //Increase textbox for more digits

      
      
      
      
      /* Set text properties to white and right aligned for the dynamic text */ 
      textProperties.fontColor = COLOR_WHITE;
      textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
      oled.SetTextProperties(&textProperties);  
      
      
      strcpy((char *) text1,"X-Axis (uT):");
      oled.Label((uint8_t *)text1,3,45);      
      
      /* Format the value */
      sprintf(text1,"%4.2f",mx);
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
      oled.TextBox((uint8_t *)text1,70,45,20,15); //Increase textbox for more digits

      /* Set text properties to white and right aligned for the dynamic text */ 
      textProperties.fontColor = COLOR_GREEN;
      textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
      oled.SetTextProperties(&textProperties);  

      /* Display Legends */
      strcpy((char *) text2,"Y-Axis (uT):");
      oled.Label((uint8_t *)text2,3,62); 
      
      /* Format the value */
      sprintf(text2,"%4.2f",my);
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
      oled.TextBox((uint8_t *)text2,70,62,20,15); //Increase textbox for more digits
      
      /* Set text properties to white and right aligned for the dynamic text */ 
      textProperties.fontColor = COLOR_RED;
      textProperties.alignParam = OLED_TEXT_ALIGN_LEFT;
      oled.SetTextProperties(&textProperties);  
      
      /* Display Legends */
      strcpy((char *) text3,"Z-Axis (uT):");
      oled.Label((uint8_t *)text3,3,79);       
      
      /* Format the value */
      sprintf(text3,"%4.2f",mz);
      /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
      oled.TextBox((uint8_t *)text3,70,79,20,15); //Increase textbox for more digits

      led1 = !led1;
      Thread::wait(250);
    }
}

 
 




