/*
Copyright (c) 2011 blmarket.net
*/
/*
Copyright (c) 2010 Peter Barrett

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"
#include "FATFileSystem.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX);
TextLCD lcd(p21, p23, p22, p27, p28, p29, p30); // rs, rw, e, d0-d3
EthernetNetIf eth(
  IpAddr(110,76,72,244), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(110,76,72,1), //Gateway
  IpAddr(143,248,1,177)  //DNS
);
HTTPClient *twitterclient = NULL; // will be set by initialization func.

u8 prevkey[8] = {0};
char keyMap[256] = {0,0,0,0,'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z',0,0,0,0,0,0,0,0,0,0,0/*return*/,0,0,0,' '};

int msglen = 0;
char msgtxt[256];
bool needcls = false;

void sendTweet(void)
{
    if(msglen == 0) return;
    if(twitterclient == NULL) return;
    HTTPMap msg;
    msg["status"] = msgtxt;
    
    twitterclient->basicAuth("blmarketmbed", "1324"); //We use basic authentication, replace with you account's parameters
    
    //No need to retieve data sent back by the server
    HTTPResult r = twitterclient->post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
    if( r == HTTP_OK )
    {
        printf("Tweet sent with success!\n");
        lcd.cls();
        lcd.printf("Tweet success!\nType Tweet msg\n");
    }
    else
    {
        printf("Problem during tweeting, return code %d\n", r);
        lcd.cls();
        lcd.printf("Tweet failure\n");
    }
    needcls = true;
    
    msglen = 0;
    msgtxt[msglen]=0;
}

void onPressedKey(u8 value)
{
    if(value == 40)
    {
        sendTweet();
        return;
    }
    
    if(keyMap[value] != 0)
    {
        if(msglen >= 32) return;
        if(needcls)
        {
            lcd.cls();
            needcls = false;
        }
        lcd.printf("%c",keyMap[value]);
        msgtxt[msglen++] = keyMap[value];
        msgtxt[msglen] = 0;
    }
    else
    {
        printf("Unknown keycode %d\n",value);
    } 
}

void HandleKeyboardCallback(u8 *data, int len)
{
    if(len != 8)
    {
        printf("Wrong KeyboardCallback : len should be 8\n");
        return;
    }
    
    for(int i=2;i<len;i++) if(data[i] != 0)
    {
        bool omit = false;
        for(int j=2;j<len;j++)
        {
            if(prevkey[j] == data[i]) 
            {
                omit = true;
                break;
            }
        }
        if(omit) continue;
        onPressedKey(data[i]);        
    }
    memcpy(prevkey, data, sizeof(u8)*len);    
}

int main() 
{
    printf("Init\n");
    lcd.printf("TwitterClient\nLoading...\n");

    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("\r\nSetup OK\r\n");

    pc.baud(9600);
    USBInit();
    
    twitterclient = new HTTPClient();
    
    lcd.cls();
    lcd.printf("Type Tweet msg\n");
    needcls = true;
    
    while(1)
    {
        USBLoop();
    }
    
/*
    printf("\r\nSetting up...\r\n");
    
    HTTPClient twitter;
    
    HTTPMap msg;
    msg["status"] = "Now I need to attach my USB keyboard to mbed"; //A good example of Key/Value pair use with Web APIs
    
    twitter.basicAuth("blmarketmbed", "1324"); //We use basic authentication, replace with you account's parameters
    
    //No need to retieve data sent back by the server
    HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
    if( r == HTTP_OK )
    {
        printf("Tweet sent with success!\n");
        lcd.printf("Tweet success!\n");
    }
    else
    {
        printf("Problem during tweeting, return code %d\n", r);
        lcd.printf("Tweet failure\n");
    }
*/    
  
    return 0;
}

