#include "mbed.h"
#include "CSVParser.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"
#include <vector>
#include <functional>

#define ARRAYSIZE(arr) (int)(sizeof(arr) / sizeof(arr[0]))
#define min(a,b) (((a)<(b))?(a):(b))

typedef void (*menuftn)(void *);

using namespace std;

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
EthernetNetIf eth;
/*
(
  IpAddr(110,76,72,244), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(110,76,72,1), //Gateway
  IpAddr(143,248,1,177)  //DNS
);
*/
HTTPClient http;
TextLCD lcd(p21, p23, p22, p27, p28, p29, p30); // rs, rw, e, d0-d3

vector<StockData *> stocks;

void donothing(void *) {}

void fetchStockData(void *)
{
    lcd.cls();
    lcd.printf("Fetching...");
    stocks.clear();
    
    HTTPText txt;
    HTTPResult r2 = http.get("http://download.finance.yahoo.com/d/quotes.csv?f=snl1d1c1p2&e=.csv&s=000660.KS,067250.KS", &txt);
    if(r2 == HTTP_OK)
    {
        printf("HTTP_OK\n");
                
        char data[1024];
        int len = strlen(txt.gets());
        
        if(len >= 1024)
        {
            pc.printf("Result too Long!\n");
            return;
        }        
        
        strcpy(data, txt.gets());
        int prevpos = 0;
        for(int i=0;i<len;i++)
        {
            if(data[i] == 13 && data[i+1] == 10)
            {
                data[i]=0;
                stocks.push_back(CSVParser::parseResult(data + prevpos)); // needs to be freed using delete
                prevpos = i+2;
            }
        }
    }
    else
    {
        pc.printf("Error %d\n", r2);
    }
}

void clearStocks() { for(int i=0;i<stocks.size();i++) delete stocks[i]; stocks.clear(); }

void showMenu(int menucnt, const char *menus[], int cursor, int screenpos)
{
    if(menucnt == 0) return;
    lcd.cls();
    lcd.printf("%s\n", menus[screenpos]);
    lcd.printf("%s\n", menus[(screenpos+1)%menucnt]);
    lcd.locate(15, cursor==screenpos?0:1);
    lcd.putc(0);
}

void showStock(StockData *data)
{
    char menu[20][50];
    char *menuptr[20];
    
    int menucnt = min(CSVParser::fields.size(),20);
    
    for(int i=0;i<menucnt;i++)
    {
        sprintf(menu[i], "%s : %s", CSVParser::fields[i].second.c_str(), data->field[i]);
        menuptr[i] = menu[i];
    }
    
    int cursor = 0;    
    while(true)
    {
        lcd.cls();
        lcd.printf("%s\n", menuptr[cursor]);
        char ch = getchar();
        switch(ch)
        {
            case 'i':
                return;
            case 'j':
                cursor = (cursor + 1) % menucnt;
                break;
            case 'k':
                cursor = (cursor - 1 + menucnt) % menucnt;
                break;
        }
    }    
    return;
}

void listStocks(void *)
{
    const char *menu[20];
    int menucnt = stocks.size();
    for(int i=0;i<menucnt;i++)
        menu[i] = stocks[i]->field[1];
        
    if(menucnt == 0) return;
        
    int cursor = 0, screenpos = 0;
    while(true)
    {
        showMenu(menucnt, menu, cursor, screenpos);
        char ch = getchar();
        switch(ch)
        {
            case 'i':
                return;
            case 'j':
                if(screenpos != cursor)
                {
                    screenpos = (screenpos + 1) % menucnt;
                }
                cursor = (cursor + 1) % menucnt;
                break;
            case 'k':
                if(screenpos == cursor)
                {
                    cursor = (cursor - 1 + menucnt) % menucnt;
                    screenpos = cursor;
                }
                else
                {
                    cursor = (cursor - 1 + menucnt) % menucnt;
                }
                break;
            case 32: // space
                showStock(stocks[cursor]);
                break;            
        }
    }
}

void startMenu(void *)
{
    int pattern[8];
    pattern[0] = 0x1;
    pattern[1] = 0x3;
    pattern[2] = 0x7;
    pattern[3] = 0xf;
    pattern[4] = 0xf;
    pattern[5] = 0x7;
    pattern[6] = 0x3;
    pattern[7] = 0x1;
  
    lcd.writeCGRAM(0, pattern);
  
    //lcd.locate(15,0);
    //lcd.putc(0);   // user pattern 0
    
    const char *menu[] = { "Get Data", "List Data", "Do Some", "Menu Test" };    
    menuftn ftn[] = { fetchStockData, listStocks, donothing, donothing };
    int menucnt = 4;    
    
    int cursor = 0, screenpos = 0;

    while(true)
    {
        showMenu(menucnt, menu, cursor, screenpos);    

        char ch = getchar();
        switch(ch)
        {
            case 'j':
                if(screenpos != cursor)
                {
                    screenpos = (screenpos + 1) % menucnt;
                }
                cursor = (cursor + 1) % menucnt;
                break;
            case 'k':
                if(screenpos == cursor)
                {
                    cursor = (cursor - 1 + menucnt) % menucnt;
                    screenpos = cursor;
                }
                else
                {
                    cursor = (cursor - 1 + menucnt) % menucnt;
                }
                break;
            case 32: // space
                ftn[cursor](NULL);
                break;            
        }
    }    
}

int main() 
{
    lcd.cls();
    /* setting fields information of Yahoo! finance */
    char *fields[] = { "s", "n", "l1", "d1", "c1", "p2" };
    char *desc[] = { "Symbol", "Name", "Last Trade", "Last Trade Date", "Change", "Change in Percent" };   
    
    lcd.printf("Init...");

    pc.baud(9600);
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        pc.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    pc.printf("\r\nSetup OK\r\n");
    
    pc.printf("CSVParser Fields Input\r\n");
    
    CSVParser::fields.clear();

    for(int i=0;i<ARRAYSIZE(fields);i++)
    {
        pc.printf("pushing %s %s\n", fields[i], desc[i]);
        CSVParser::fields.push_back(make_pair(fields[i], desc[i]));
    }
    
    pc.printf("CSVParser Setup OK\r\n");    
    
    lcd.cls();
    
    startMenu(NULL);
    
/*
    for(int i=0;i<min(2, stocks.size());i++)
    {
        StockData *data = stocks[stocks.size()-1-i];
        lcd.printf("%s\n",data->field[1]);
    }
*/    

    clearStocks();
    
    while(1) {}
}
