/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_BUTTON_SERVICE_H__
#define __BLE_BUTTON_SERVICE_H__

class ButtonServiceA
{
public:
    const static uint16_t BUTTON_SERVICE_UUID              = 0xA000;
    const static uint16_t BUTTON_STATE_CHARACTERISTIC_UUID = 0xA001;

    ButtonServiceA(BLEDevice &_ble, bool buttonPressedInitial) :
        ble(_ble), buttonState(BUTTON_STATE_CHARACTERISTIC_UUID, &buttonPressedInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
        GattCharacteristic *charTable[] = {&buttonState};
        GattService         buttonService(ButtonServiceA::BUTTON_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(buttonService);
    }

    void updateButtonState(int newState) {
        ble.updateCharacteristicValue(buttonState.getValueHandle(), (uint8_t *)&newState, sizeof(bool));
    }

private:
    BLEDevice                        &ble;
    ReadOnlyGattCharacteristic<bool>  buttonState;
};

class ButtonServiceB
{
public:
    const static uint16_t BUTTON_SERVICE_UUID              = 0xB000;
    const static uint16_t BUTTON_STATE_CHARACTERISTIC_UUID = 0xB001;
    const static uint16_t READWRITE_CHARACTERISTIC_UUID = 0xB002;

    ButtonServiceB(BLEDevice &_ble, bool buttonPressedInitial) :
        ble(_ble),
        buttonState(BUTTON_STATE_CHARACTERISTIC_UUID, &buttonPressedInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        readWrite(READWRITE_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ)  {
            
        GattCharacteristic *charTable[] = {&buttonState, &readWrite};
        GattService         buttonService(ButtonServiceB::BUTTON_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(buttonService);
    }

    void updateButtonState(int newState) {
        ble.updateCharacteristicValue(buttonState.getValueHandle(), (uint8_t *)&newState, sizeof(bool));
    }

private:
    BLEDevice                        &ble;
    ReadOnlyGattCharacteristic<bool>  buttonState;
    ReadWriteGattCharacteristic<uint8_t>  readWrite;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
