#include "mbed.h"
#include "rtos.h"
#include "ATParser.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include  "Speaker.h"
//#include "wave_player.h"
#include <string>
#include <iostream>
using namespace std;

//General setups
DigitalOut cmdMode(p18);
Serial pc(USBTX, USBRX);
BufferedSerial ble(p13,p14);
DigitalOut cmdstuff(p18);
DigitalOut greenLED(p24);
DigitalOut yellowLED(p25);
DigitalOut redLED(p26);
uLCD_4DGL uLCD(p28,p27,p30);
SDFileSystem sd(p5, p6, p7, p8, "sd");

Semaphore sem(0);
//Speaker mySpeaker(p21);

//AT command data handlers
bool datalogged = 0;
char delimiter[] = "\r\n";
int buffer_size = 256;
int timeout = 100;
bool debug = false;
ATParser at(ble, delimiter, buffer_size, timeout, debug);
char buffer[10];
volatile int risk_level = 0;
int temp_risk = -1;
int changed = 0;

//RTOS Mutex Lock
Mutex mutex_lock;
Mutex lcd_lock;

//Global Data points and arrays
int averageCount = 0;
volatile int RSSI_array[15];

//This portion of the code handles RSSI readings

int calculate_average(volatile int *input, int size)
{
    int average;
    for(int i = 0; i< size; i++) {
        average = average + input[i];
    }
    average = average/size;
    return average;
}

void parse_RSSI()
{
    mutex_lock.lock();
    at.send("AT+BLEGETRSSI") && at.read(buffer, 10);
    if(buffer[0] == '-') {
        //datalogged = 1;
        pc.printf("RSSI: ");
        pc.putc(buffer[1]);
        pc.putc(buffer[2]);
        pc.printf("\n");
        int digit1 = buffer[1] - 48;
        int digit2 = buffer[2] - 48;
        int total = 10*digit1 + digit2;
        if (averageCount <= 15) {
            RSSI_array[averageCount] = total;
        }
        averageCount++;
        if(averageCount > 15 && buffer[0] == '-') {
            
            averageCount = 0;
            int average = calculate_average(RSSI_array, 15);
            if(average < 55) {
                temp_risk = 3;
            } else if(average > 55 && average < 70) {
                temp_risk = 2;
            } else if(average > 70 && average < 90) {
                temp_risk = 1;
            } else {
                temp_risk = 0;
            }
            if(risk_level != temp_risk) {
                risk_level = temp_risk;
                changed = 1;
            }
        }
        pc.printf("Risk level: ");
        pc.printf("%i\n", risk_level);
    } else {
        pc.printf("Disconnected\n");
        datalogged = 0;
    }
    mutex_lock.unlock();
}

//This portion of the code handles peripherals
/*
void speaker_alarm()
{
    while(1){
        if(risk_level >= 2 && datalogged){
            mySpeaker.PlayNote(969.0, 0.5, 1.0);
            mySpeaker.PlayNote(800.0, 0.5, 1.0);
        }else{
            mySpeaker.PlayNote(0.0, 0.0, 0.0);
        }
    }
}
*/

void logging_SD_card()
{

}

void blink_leds()
{
    while(1){
        if(risk_level <= 1){
            greenLED = 1;
            redLED = 0;
            yellowLED = 0;
        }else if(risk_level == 2){
            yellowLED = 1;
            greenLED = 0;
            redLED = 0;
        }else if(risk_level == 3){
            redLED = 1;
            yellowLED = 0;
            greenLED = 0;
        }else{
            redLED = 0;
            yellowLED = 0;
            greenLED = 0;
        }
    }
}

void display_ulcd()
{
    mutex_lock.lock();
    uLCD.color(WHITE);
    mutex_lock.unlock();
    while(1){
        mutex_lock.lock();
        if (changed) {
            if(risk_level <= 1){
                uLCD.cls();
                uLCD.locate(5, 7);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.background_color(GREEN);
                uLCD.textbackground_color(GREEN);
                uLCD.printf("Safe");
            }else if(risk_level == 2){
                uLCD.cls();
                uLCD.locate(1, 7);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.background_color(0xFFFF00);
                uLCD.textbackground_color(0xFFFF00);
                uLCD.printf("Cautious");
            }else if(risk_level == 3){
                uLCD.cls();
                uLCD.locate(3, 7);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.background_color(RED);
                uLCD.textbackground_color(RED);
                uLCD.printf("Hazard");
            }else{
                uLCD.background_color(BLACK);
                uLCD.printf("waiting");
            }
            changed = 0;
        }
        mutex_lock.unlock();
    }
}

int main()
{
    cmdstuff = 1;
    at.send("AT") && at.recv("OK");
    at.send("AT+AB ChangeDefaultBaud [9600]", 3) && at.recv("OK");
    pc.baud(9600);
    ble.baud(9600);

    //Thread SD_Thread();
    Thread ULCD_Thread(display_ulcd);
    Thread LED_Thread(blink_leds);
    //Thread Speaker_Thread(speaker_alarm);
    
    while(1) {
        parse_RSSI();
    }
}