#include "mbed.h"
#include "rtos.h"
#include "ATParser.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include  "Speaker.h"
//#include "wave_player.h"
#include <string>
#include <iostream>
using namespace std;

//Hardware setup
DigitalOut cmdMode(p18);
Serial pc(USBTX, USBRX);
BufferedSerial ble(p13,p14);
DigitalOut cmdstuff(p18);
DigitalOut greenLED(p24);
DigitalOut yellowLED(p25);
DigitalOut redLED(p26);
uLCD_4DGL uLCD(p28,p27,p30);
SDFileSystem sd(p5, p6, p7, p8, "sd");
//Speaker mySpeaker(p21);

//AT command data structures
char delimiter[] = "\r\n";
int buffer_size = 256;
int timeout = 100;
bool debug = false;
ATParser at(ble, delimiter, buffer_size, timeout, debug);
char buffer[10];

//RSSI data
int averageCount = 0;
volatile int RSSI_array[15];
volatile int risk_level = 0;
volatile int changed = 0;

//RTOS Mutex Lock
Mutex serial_lock;

//Time variable
time_t seconds;

//Function to store data to sd card
void log_sd_card()
{
    serial_lock.lock();
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    int curr_time = (int)ctime(&seconds) % 86400;
    int curr_hour = curr_time / 3600;
    int curr_min = curr_time / 60;
    int curr_sec = curr_time % 60;
    
    
    fprintf(fp, "Date & time: Tuesday 28, April 2020 ");
    fprintf(fp, "%i", curr_hour);
    fprintf(fp, ":");
    fprintf(fp, "%i", curr_min);
    fprintf(fp, ":");
    fprintf(fp, "%i", curr_sec);
    fprintf(fp, "\n");
    fprintf(fp, "Risk Level: ");
    fprintf(fp, "%i", risk_level);
    fprintf(fp, "\n");
    for (int i = 0; i < 15; i++) {
        fprintf(fp, "%i", RSSI_array[i]);
        if (i < 14) {
            fprintf(fp, ", ");   
        }
    }
    fprintf(fp, "\n\n");
    fclose(fp);
    serial_lock.unlock();
}

//Helper function for parse_RSSI
int calculate_average(volatile int *input, int size)
{
    int average;
    for(int i = 0; i< size; i++) {
        average = average + input[i];
    }
    average = average/size;
    return average;
}

//This portion of the code handles RSSI readings
void parse_RSSI()
{
    serial_lock.lock();
    at.send("AT+BLEGETRSSI") && at.read(buffer, 10);
    if(buffer[0] == '-') {
        //Getting RSSI number
        int digit = 1;
        int total = 0;
        for (int i = 0; i < 10; i++) {
            if (buffer[i] > 47 || buffer[i] < 58) {
                total += (buffer[i] * digit);
                digit = digit*10;
            } else if (buffer[i] == 92) {
                break;
            }
        }
        
        //Printing for confirmation
        pc.printf("RSSI: ");
        pc.printf("%s", buffer);
        pc.printf("\n");
        
        //Store for average
        if (averageCount <= 15) {
            RSSI_array[averageCount] = total;
        }
        averageCount++;
        
        //Calculate average and update risk level
        if(averageCount > 15) {
            averageCount = 0;
            int average = calculate_average(RSSI_array, 16);
            int temp_risk_level;
            if(average < 55) {
                temp_risk_level = 3;
            } else if(average > 55 && average < 70) {
                temp_risk_level = 2;
            } else if(average > 70 && average < 90) {
                temp_risk_level = 1;
            } else {
                temp_risk_level = 0;
            }
            if(temp_risk_level != risk_level){
                changed = 1;
            }
            risk_level = temp_risk_level;
            serial_lock.unlock();
            log_sd_card();
        }
    }
    serial_lock.unlock();
}

//This portion of the code handles peripherals
/*
void speaker_alarm()
{
    while(1){
        if(risk_level >= 2 && datalogged){
            mySpeaker.PlayNote(969.0, 0.5, 1.0);
            mySpeaker.PlayNote(800.0, 0.5, 1.0);
        }else{
            mySpeaker.PlayNote(0.0, 0.0, 0.0);
        }
    }
}
*/

void blink_leds()
{
    while(1){
        if(risk_level <= 1){
            greenLED = 1;
            redLED = 0;
            yellowLED = 0;
        }else if(risk_level == 2){
            yellowLED = 1;
            greenLED = 0;
            redLED = 0;
        }else if(risk_level == 3){
            redLED = 1;
            yellowLED = 0;
            greenLED = 0;
        }else{
            redLED = 0;
            yellowLED = 0;
            greenLED = 0;
        }
    }
}

void display_ulcd()
{
    serial_lock.lock();
    uLCD.color(WHITE);
    serial_lock.unlock();
    while(1){
        if (changed) {
            serial_lock.lock();
            if(risk_level <= 1){
                uLCD.cls();
                uLCD.locate(5, 7);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.background_color(GREEN);
                uLCD.textbackground_color(GREEN);
                uLCD.printf("Safe");
            } else if(risk_level == 2){
                uLCD.cls();
                uLCD.locate(1, 7);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.background_color(0xFFFF00);
                uLCD.textbackground_color(0xFFFF00);
                uLCD.printf("Cautious");
            } else if(risk_level == 3){
                uLCD.cls();
                uLCD.locate(3, 7);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.background_color(RED);
                uLCD.textbackground_color(RED);
                uLCD.printf("Hazard");
            }
            changed = 0;
            serial_lock.unlock();
        }
    }
}

int main()
{
    //Bluetooth initialization
    cmdstuff = 1;
    at.send("AT") && at.recv("OK");
    at.send("AT+AB ChangeDefaultBaud [9600]", 3) && at.recv("OK");
    pc.baud(9600);
    ble.baud(9600);\
    
    //Time initialization
    set_time(1588089600);  // Set RTC time to Tuesday 28, April 2020 16:00:00
    seconds = time(NULL);
    
    //SD card initialization
    mkdir("/sd/mydir", 0777);

    //Starting threads
    //Thread SD_Thread();
    Thread ULCD_Thread(display_ulcd);
    Thread LED_Thread(blink_leds);
    //Thread Speaker_Thread(speaker_alarm);
    
    while(1) {
        parse_RSSI();
    }
}