#define DELTA_T 0.004   //処理周期4msec
#define KP 0.4          //比例定数
#define KI 0.4f          //積分定数
#define KD 0.4        //微分定数
#define n  1          //最大値最小値設定
#define arm_time 6.5  //アームの時間
#define speed02 0.8f

mbed::PwmOut mypwm011(PC_6);
PwmOut mypwm012(PB_15);    //モーター１

PwmOut mypwm021(PB_14);
PwmOut mypwm022(PB_13);    //モーター２

PwmOut mypwm030(PC_9);    //アームのモータ？
PwmOut mypwm031(PC_8);
#define ROTATE_PER_REVOLUTIONS  24
QEI wheel01(   PA_8,PB_10,     //A相のピン、B相のピン
             NC,                             //回転数数えるピン（任意）
             ROTATE_PER_REVOLUTIONS,                          //1回転につき何パルスの出力をするか？
             QEI::X2_ENCODING );         //モード設定、X4_ENCODING→分解能が細かくなるが精度低い
             
QEI wheel02(   D3,D2,     //A相のピン、B相のピン
             NC,                             //回転数数えるピン（任意）
             ROTATE_PER_REVOLUTIONS,                          //1回転につき何パルスの出力をするか？
             QEI::X2_ENCODING );         //モード設定、X4_ENCODING→分解能が細かくなるが精度低い

//DigitalOut myled(LED1);     //特に必要性のないLED定義
typedef signed long S32;
typedef float F32;
static S32 diff[2];
static F32 integral;

F32 pid_sample(int a,int b)
{
    float turn;
    F32 p,i,d;
    i += 0.0f;
    diff[0] = diff[1];
    diff[1]= a - b;
    integral += (diff[1]+diff[0])/2.0*DELTA_T+ 0.0f;
    
    p = KP*diff[1];
    i = KI * integral;
    d = KD *(diff[1]-diff[0])/DELTA_T;
    
    turn = speed02 - (p + i + d);
    
    if(n<turn)turn = n;
    if(-n>turn)turn = -n;    //最大値最小値の設定
    
    return turn;
    }
void Motor01(float a)
{
    if(a>0&&a<=1)
    {mypwm011 = 1;mypwm012 = 1 - a;} //正転
    
    else if(a<=0&&a>=-1)
    {mypwm011 = 1 + a;mypwm012 = 1;} //逆転&a=0ならブレーキ
    
    else
    {mypwm011 = 0;mypwm012 = 0;} //ストップ
}

void Motor02(float a)
{
    if(a>0&&a<=1)
    {mypwm021 = 1;mypwm022 = 1 - a;} //正転
    
    else if(a<=0&&a>=-1)
    {mypwm021 = 1 + a;mypwm022 = 1;} //逆転&a=0ならブレーキ
    
    else
    {mypwm021 = 0;mypwm022 = 0;} //ストップ
}

void Motor03(float a)
{
    if(a>0&&a<=1)
    {mypwm030 = 1;mypwm031 = 1 - a;} //正転
    
    else if(a<=0&&a>=-1)
    {mypwm030 = 1 + a;mypwm031 = 1;} //逆転&a=0ならブレーキ
    
    else
    {mypwm030 = 0;mypwm031 = 0;} //ストップ
}