# include "mbed.h"

DigitalOut a(p24);
DigitalOut b(p17);
DigitalOut c(p16);
DigitalOut d(p14);
DigitalOut e(p15);
DigitalOut f(p25);
DigitalOut g(p22);
DigitalOut dp(p23);

DigitalOut cat1(p21);
DigitalOut cat2(p20);

DigitalOut cat[] = {cat1, cat2};
DigitalOut display[] = {a, b, c, d, e, f, g};

const int digits[10][7] = {
        {1, 1, 1, 1, 1, 1, 0},
        {0, 1, 1, 0, 0, 0, 0},
        {1, 1, 0, 1, 1, 0, 1},
        {1, 1, 1, 1, 0, 0, 1},
        {0, 1, 1, 0, 0, 1, 1},
        {1, 0, 1, 1, 0, 1, 1},
        {1, 0, 1, 1, 1, 1, 1},
        {1, 1, 1, 0, 0, 0, 0},
        {1, 1, 1, 1, 1, 1, 1},
        {1, 1, 1, 1, 0, 1, 1}
};

void display_num(float num) {
    int dpi = 1;
    int numi = (int)(num);
    
    if (((int)num)/10 == 0) {
        dpi = 0;
        numi = (int)(num*10);
    }
    
    int disp_digits[] = {numi/10, numi%10};
    
    for (int d=0; d<2; d++) {
        cat[d] = 1;
        cat[(d+1)%2] = 0;
        for (int seg=0; seg<7; seg++) {
            display[seg] = digits[disp_digits[d]][seg];
        }
        for (int seg=0; seg<7; seg++) {
            display[seg] = 0;
        }
        if (d == dpi) {
            dp = 1;
            dp = 0;
        }
    }    
}