# include "mbed.h"
# include "rtos.h"
# include "Timer.h"
# include "displayDriver.h"

# include <time.h>
# define NUM_HOLES 32
# define CIRCUMFRENCE_CM 48.6946861

# define LIGHT_SENSOR_PIN p18
# define FLASH_THRESHOLD 0.02
# define PERIOD_MS 500
# define RUNTIME 120000 // 2 mins


AnalogIn lightSensorVoltage(LIGHT_SENSOR_PIN);
Serial pc(USBTX, USBRX);

float velocity = 0.0; // used by display thread

void sendFloat(float value) {
    for (int i=0; i<4; i++)
        pc.putc(*(((char*) &value)+i));
}

void displayThread_cb() {
    while(velocity >= 0) {
        display_num(velocity);
    }
    return;
}

int main() {
    Thread displayThread;
    displayThread.start(displayThread_cb);
    
    Timer t0;
    t0.start();
    
    while(t0.read_ms() < RUNTIME) {
        float minVoltage = 1.1; // voltage will never go above 1.0
        int voltagePeaks = 0;
        
        Timer t1;
        t1.start();
        
        while(t1.read_ms() < PERIOD_MS) {
            float currVoltage = lightSensorVoltage.read();
            if(currVoltage < minVoltage) {
                minVoltage = currVoltage;
            } else if (currVoltage - minVoltage > FLASH_THRESHOLD) {
                voltagePeaks++;
                minVoltage = 1.1;
            }
            wait(0.01);
        }
        
        t1.stop();
        
        // calculate velocity
        velocity = (voltagePeaks * CIRCUMFRENCE_CM * 1000) / (NUM_HOLES * PERIOD_MS);
        
        //send 
        sendFloat(velocity);
    }
    
    t0.stop();
    velocity = -1; // tells the display thread to stop
    displayThread.join();
    
    return 0;    
}