    AREA my_asm, CODE, READONLY
; Export my_leds function symbol for linker
    EXPORT my_leds
my_leds
;
; ARM Assembly language function to set LEDs to a value passed from C   
; LEDs get low order nybble (passed from C compiler in R0)
; Destination bits are 23, 21, 20, 18 for bits 3, 2, 1, 0 respectively
;
; Load GPIO Port 1 base address in register R1 
    PUSH    {R1, R2, LR}
    LDR     R1, =0x2009C03C    ; 0x2009C03C = FIOCLR address
    LDR     R2, =0xB40000      ; Pattern for all lights
    STR     R2, [R1]           ; Clear all lights
    LDR     R1, =0x2009C038    ; 0x2009C038 = FIOSET address

    BFI     R2, R0, #20, #4    ; Insert bit 3 in the correct position
    BFI     R2, R0, #19, #3    ; Insert bits 1 and 2 in the correct position
    BFI     R2, R0, #18, #1    ; Insert bit 1 in the correct position

    AND     R2, R2, #0xB40000  ; Apply bit mask
    
    STR     R2, [R1]           ; Store R2 at FIOSET address to light LEDs
    
    BL      my_wait            ; Branch to my_wait subroutine
    POP     {R1, R2, LR}
    BX      LR                 ; Return from function
    ALIGN                      ; Pad for word alignment
    
my_wait
    PUSH    {R4, R5}        ;get 2 regs to use R4 is i, R5 is limit
    MOV.W   R4, #0          ;int i = 0
    LDR     R5, =20000000   ;Set limit
loop_entry
    CMP     R4, R5          ;R4 - R5 (i - limit)
    BGE     loop_exit       ;if i >= limit exit
                            ;loop body is empty
    ADD     R4, R4, #1      ;i++
    B       loop_entry      ;Return
loop_exit
    POP     {R4, R5}        ;restore regs    
    BX      LR              ;Return
    ALIGN
    END
    
    END                        ; End of assembly