#include "mbed.h"
#include "LSM9DS1.h" //Accelerometer
#include "uLCD_4DGL.h" //LCD  
#include "mbed.h"
#include "Servo.h"

#include <mpr121.h>
#include <string>
#include <list>



Servo myservo(p22); //servo

uLCD_4DGL uLCD(p13, p14, p29); // serial tx, serial rx, reset pin;

//Mutex LCDMutex;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
int passIndex = 0;
//Change password here. 
int password[4] = {1, 32, 1024, 2048};
int attempt[4];
int correct = 1; //correct is 1 if they havent put in 3 digits. it's 2 if they're correct and it's 3 if they are incorrect.

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p21);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p28, p27);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

Serial pc(USBTX, USBRX);

AnalogIn in(p20); //Proximity
float voltage;

Serial bluemod(p9,p10);

void fallInterrupt()
{
    //pc.printf("Start interrupt");
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    //pc.printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
    }

    if (value !=0) {

        attempt[passIndex] = value;
        //uLCD.printf(" %d    %x \n", passIndex, value);
        uLCD.printf("   *");
        passIndex++;
        if (passIndex == 4) {

            if (attempt[0] == password[0] && attempt[1] == password[1] && attempt[2] == password[2] && attempt[3] == password[3]) {
                correct = 2;
            } else {
                correct = 3;
            }
            passIndex = 0;
            for (int k = 0; k < 4; k++)
                attempt[k] = NULL;
        }

    }


    //uLCD.printf("number pressed is %d\n", key_code);
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
}

int main()
{

    //Inclue this if you have gyroscope connected. We only had 3 Serial buses so we were unable to use the gyroscope.
    /*LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
    IMU.begin();
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.readGyro();
    float xval = IMU.calcGyro(IMU.gx);
    float yval = IMU.calcGyro(IMU.gy);
    float zval = IMU.calcGyro(IMU.gz);
    */

    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);

    uLCD.printf("Enter code for \ncandy\n");

    while(1) {
        //Inclue this if you have gyroscope connected. We only had 3 Serial buses so we were unable to use the gyroscope.
        /*//Checking if someone is skaing the machine
        while(!IMU.gyroAvailable())
            IMU.readGyro();
        if (abs(xval - IMU.calcGyro(IMU.gx)) > 10 || abs(yval - IMU.calcGyro(IMU.gy)) > 10 || abs(zval - IMU.calcGyro(IMU.gz)) > 10) {
            uLCD.cls();
            uLCD.printf("Don't shake the machine!\n");
            wait(2.0);
            for (int i = 3; i > 0; i--) {
                uLCD.cls();
                uLCD.printf("Machine stopped\n for: %d Second(s)", i);
                wait(1.0);
            }
            uLCD.cls();
            uLCD.printf("Enter code for \n candy\n");
        }
        IMU.readGyro();
        xval = IMU.calcGyro(IMU.gx);
        yval = IMU.calcGyro(IMU.gy);
        zval = IMU.calcGyro(IMU.gz);
        */
        while(bluemod.readable()) {
            if (bluemod.getc() == 'd') {
                correct = 4;
                bluemod.puts("Dispensing Candy!");
            }
            if (bluemod.getc() == 'c') {
                voltage = in.read();

            }
        }

        if(correct == 2) { // They inputted the correct password
            uLCD.cls();
            uLCD.printf("Correct Password! \n\n\n Dispensing Candy!");
            myservo = 1;
            wait(1.3333);
            myservo = 0.5;
            uLCD.cls();
            uLCD.printf("Enjoy!");
            wait(2.0);
            uLCD.cls();
            wait(0.2);
            correct = 1;
            uLCD.printf("Enter code for \ncandy\n");
        }
        if(correct == 3) { // they inputted the incorrect password
            uLCD.cls();
            uLCD.printf("Incorrect Password\n\n Try again.");
            wait(2.0);
            correct = 1;
            uLCD.cls();
            uLCD.printf("Enter code for \ncandy\n");
        }
        if(correct == 4) { // They inputted the correct password
            uLCD.cls();
            uLCD.printf("Dispensing via\nbluetooth!");
            myservo = 1;
            wait(1.3333);
            myservo = 0.5;
            uLCD.cls();
            uLCD.printf("Enjoy!");
            wait(2.0);
            uLCD.cls();
            wait(0.2);
            correct = 1;
            uLCD.printf("Enter code for \ncandy\n");
        }


    }
}
