
#include "mbed.h"
#include "PinDetect.h"
#include "uLCD_4DGL.h"
#include <string>
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
uLCD_4DGL lcd(p28, p27, p30);
DigitalOut myled(LED1);
PinDetect pb1(p9);
PinDetect pb2(p10);
PinDetect pb3(p11);
PinDetect pb4(p12);

int randseed = 0; // seed for random number generator

int bet = 0;// initial bet
int dollars = 100; // money your wife let you take to the casino

string playerblackjackstring = "";
string dealerblackjackstring = "";
int playercardnumbers[26] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; // initial player hand matrix
int dealercardnumbers[26]= {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; // inital dealer hand matrix
string playercardstring[26] = {"","","","","","","","","","","","","","","","","","","","","","","","","",""}; // string array for printing letters/numbers on cards
string dealercardstring[26] = {"","","","","","","","","","","","","","","","","","","","","","","","","",""}; // see above
int playerindex = 0;
int dealerindex = 0;

string winloss = "";
int holdvalue =0;
int numberofaces = 0;// for calculating whether ace is 1 or 11
int cardindex;// These lines are for
string cardstring = "";// the drawcard
int cardnumber;// function
int playersum = 0; // for testing player conditions
int dealersum = 0; // for testing dealer conditions

string playagainstring = "yes";
string choice = ""; // this is for the hit or stand function

void printdealercards(int a)
{
    for (int i = 0; i < a +1; i++)
        printf(" %d ", dealercardnumbers[i]);
}
void createtable()
{
    lcd.background_color(BLACKJACKRED);
    lcd.cls();
    lcd.color(WHITE);
    lcd.textbackground_color(BLACKJACKRED);
    lcd.circle(62,60,11,WHITE);
    lcd.locate(0,14);
    lcd.printf("%d", dollars);
}
void betprint(int x)
{
    lcd.locate(8,7);
    lcd.set_font_size(.5,.5);
    lcd.printf("%d",x);
}
void createdealercards()
{
    lcd.filled_rectangle(25,0,55,36,RED);
    lcd.filled_rectangle(40,0,70,36,WHITE);

}
void createplayercards()
{
    lcd.filled_rectangle(25,125,60,84,WHITE);
    lcd.filled_rectangle(50,125,70,84,WHITE);
    lcd.line(40,125,40,84,BLACK);
}
void additionalplayercards(int a)
{
    switch(a) {
        case 2:
            lcd.filled_rectangle(60,125,80,84,WHITE);
            lcd.line(52,125,52,84,BLACK);
            break;
        case 3:
            lcd.filled_rectangle(75,125,95,84,WHITE);
            lcd.line(65,125,65,84,BLACK);
            break;
        case 4:
            lcd.filled_rectangle(90,125,110,84,WHITE);
            lcd.line(80,125,80,84,BLACK);
            break;

    }
}
void printflippedcard()
{
    lcd.filled_rectangle(25,0,55,36,WHITE);
    lcd.filled_rectangle(40,0,70,36,WHITE);
    lcd.line(40,0,40,36,BLACK);
    lcd.locate(4,0);
    lcd.printf("%s",dealercardstring[0]);
    lcd.locate(6,0);
    lcd.printf("%s",dealercardstring[1]);

}
void additionaldealercard(int a)
{
    switch(a) {
        case 2:
            lcd.filled_rectangle(60,0,85,36,WHITE);
            lcd.line(55,0,55,36,BLACK);
            break;

        case 3:
            lcd.filled_rectangle(75,0,95,36,WHITE);
            lcd.line(65,125,65,84,BLACK);
            break;
        case 4:
            lcd.filled_rectangle(90,0,110,36,WHITE);
            lcd.line(80,125,80,84,BLACK);
            break;

    }
}
void betfunction()
{
    while(pb1 && pb2) {}
    if(!pb1) {
        bet = 10;
        //printf("%d\n",bet);
    }
    if(!pb2) {
        bet = 50;
        //printf("%d\n",bet);
    }
}
void drawcard()
{
    cardindex = 1 + rand()%13;

    switch(cardindex) {
        case 1:
            cardstring = "2";
            cardnumber = 2;
            break;
        case 2:
            cardstring = "3";
            cardnumber = 3;
            break;
        case 3:
            cardstring = "4";
            cardnumber = 4;
            break;
        case 4:
            cardstring = "5";
            cardnumber = 5;
            break;
        case 5:
            cardstring = "6";
            cardnumber = 6;
            break;
        case 6:
            cardstring = "7";
            cardnumber = 7;
            break;
        case 7:
            cardstring = "8";
            cardnumber = 8;
            break;
        case 8:
            cardstring = "9";
            cardnumber = 9;
            break;
        case 9:
            cardstring = "10";
            cardnumber = 10;
            break;
        case 10:
            cardstring = "J";
            cardnumber = 10;
            break;
        case 11:
            cardstring = "Q";
            cardnumber = 10;
            break;
        case 12:
            cardstring = "K";
            cardnumber = 10;
            break;
        case 13:
            cardstring = "A";
            cardnumber = 11;
            numberofaces = numberofaces + 1;
            break;
    }


}
void hitorstand()
{
    printf("Hit or Stand? \n");
    while(pb3 && pb4) {}

    if(!pb3) {
        choice = "hit";


    }
    if(!pb4) {
        choice = "stand";
    }
    printf("Choice: %s",choice);


}
void initializegame()
{
    drawcard();
    playerindex++;
    playercardnumbers[0] = cardnumber;
    playercardstring[0] = cardstring;
    drawcard();
    dealerindex++;
    dealercardnumbers[0] = cardnumber;
    dealercardstring[0] = cardstring;
    drawcard();
    playerindex++;
    playercardnumbers[1] = cardnumber;
    playercardstring[1] = cardstring;
    drawcard();
    dealerindex++;
    dealercardnumbers[1] = cardnumber;
    dealercardstring[1] = cardstring;


}
void playsum()
{
    playersum = 0;
    for(int i = 0; i < 26; i++) {

        playersum = playercardnumbers[i] + playersum;
    }

}

void dealsum()
{
    dealersum = 0;
    for(int i = 0; i < 26; i++) {

        dealersum = dealercardnumbers[i] + dealersum;
    }

}


void printinitialcardvalues(string a, string b, string c)
{
    lcd.color(BLACK);
    lcd.textbackground_color(WHITE);
    lcd.locate(4,11);
    lcd.printf("%s",a);
    lcd.locate(6,11);
    lcd.printf("%s",b);
    lcd.locate(6,0);
    lcd.printf("%s",c);


}
void printaddtionalplayervalues(string a, int b)
{
    switch(b) {
        case 2:
            lcd.locate(8,11);
            lcd.printf("%s",a);
            break;
        case 3:
            lcd.locate(10,11);
            lcd.printf("%s",a);
            break;
        case 4:
            lcd.locate(12,11);
            lcd.printf("%s",a);
            break;

    }
}
void printaddtionaldealervalues(string a, int b)

{
    switch(b) {
        case 2:
            lcd.locate(8,0);
            lcd.printf("%s",a);
            break;
    }
}
void playagain()
{
    lcd.cls();
    lcd.locate(4,8);
    lcd.textbackground_color(BLACKJACKRED);
    lcd.color(WHITE);
    lcd.printf("Play Again?");
    while(pb3 && pb4)
        if(!pb3) {
            playagainstring = "yes";
            printf("%s",playagainstring);
        }
    if(!pb4) {
        playagainstring ="no";
        printf("%s",playagainstring);
    }
}
void resetplayerarray()
{
    for(int i = 0; i <26; i++) {
        playercardnumbers[i] =0;
        playercardstring[i]= "";
    }
}
void resetdealerarray()
{
    for(int i = 0; i <26; i++) {
        dealercardnumbers[i] =0;
        dealercardstring[i]= "";
    }
}

int main()
{

    // setup pushbutton functionality
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    wait(.1);
    mkdir("/sd/mydir", 0777);
    while(playagainstring == "yes") {
        playersum = 0;
        playerindex= 0;
        dealersum = 0;
        dealerindex = 0;
        playerblackjackstring = "";
        dealerblackjackstring = "";
        winloss = "";
        holdvalue = 0;
        resetplayerarray();
        resetdealerarray();
        srand(randseed);
        // wait for pushbutton initialization
        createtable(); // this function draws the table maroon background with player betting circle
        betfunction();
        betprint(bet);
        createdealercards();//
        createplayercards();
        initializegame();
        printinitialcardvalues(playercardstring[0],playercardstring[1],dealercardstring[1]);
        dealsum();
        playsum();
        if(playersum == 21 && dealersum != 21) {
            wait(2);
            dollars = dollars + (1.5*bet);
            winloss = "win";
            lcd.cls();
            lcd.locate(2,8);
            lcd.textbackground_color(BLACKJACKRED);
            lcd.color(WHITE);
            lcd.printf("PLAYER BLACKJACK");
            playerblackjackstring = "blackjack";
        } else if(dealersum == 21 && playersum != 21) {
            wait(2);
            dollars = dollars - bet;
            winloss = "loss";
            lcd.cls();
            lcd.locate(2,8);
            lcd.textbackground_color(BLACKJACKRED);
            lcd.color(WHITE);
            lcd.printf("DEALER BLACKJACK");
            dealerblackjackstring = "blackjack";
        } else if ( playersum != 21 && dealersum != 21) {
            hitorstand();
            while(choice == "hit") {
                wait(1);
                drawcard();
                playercardnumbers[playerindex] = cardnumber;
                playercardstring[playerindex] = cardstring;
                additionalplayercards(playerindex);
                printaddtionalplayervalues(playercardstring[playerindex],playerindex);
                playerindex++;
                printf("Player Index : %d", playerindex);
                wait(1);
                playsum();
                
                if(playersum > 21 && numberofaces == 0) {
                    wait(2);
                    dollars = dollars - bet;
                    lcd.cls();
                    lcd.locate(4,8);
                    lcd.textbackground_color(BLACKJACKRED);
                    lcd.color(WHITE);
                    lcd.printf("BUST");
                    winloss = "loss";
                    break;
                    }
                else if(playersum == 21 && numberofaces >= 1){
                    numberofaces = numberofaces - 1;
                    playersum = playersum - 10;
                    }
                else if(playersum < 21) {
                    hitorstand();
                    if(choice == "stand") {
                        break;
                    }
                }
            }
            if(choice == "stand") {
                holdvalue = playersum;
                printflippedcard();
                printdealercards(25);
                dealsum();
                printf("Dealer Sum : %d\n ",dealersum);
                wait(.5);
                while(dealersum < 17) {
                    drawcard();
                    dealercardnumbers[dealerindex] = cardnumber;
                    printf(" New Card IS : %d",dealercardnumbers[dealerindex]);
                    dealercardstring[dealerindex] = cardstring;
                    additionaldealercard(dealerindex);
                    printaddtionaldealervalues(dealercardstring[dealerindex],dealerindex);
                    printdealercards(25);
                    dealsum();
                    dealerindex++;
                    if(dealersum > 21) {
                        wait(2);
                        dollars = dollars + bet;
                        lcd.cls();
                        lcd.locate(4,8);
                        lcd.textbackground_color(BLACKJACKRED);
                        lcd.color(WHITE);
                        lcd.printf(" DEALER BUST");
                        winloss = "win";
                        break;
                    }

                }//stand while
            }//stand if
        }//end else
        dealsum();
        playsum();
        //printf("Players Sum : %d  Dealer Sum: %d", playersum, dealersum);
        if((playersum > dealersum) && playerblackjackstring != "blackjack" && playersum <=21) {
            wait(2);
            dollars = dollars + bet;
            lcd.cls();
            lcd.locate(4,8);
            lcd.textbackground_color(BLACKJACKRED);
            lcd.color(WHITE);
            lcd.printf(" You Win");
            winloss = "win";
            wait(1);

        } else if (dealersum > playersum && dealerblackjackstring != "blackjack" && dealersum <= 21) {
            wait(2);
            dollars = dollars - bet;
            lcd.cls();
            lcd.locate(4,8);
            lcd.textbackground_color(BLACKJACKRED);
            lcd.color(WHITE);
            lcd.printf(" You Lose ");
            winloss = "loss";
            wait(1);
        }
        holdvalue = playersum;
        FILE *fp = fopen("/sd/mydir/stats.txt", "a");
        if(fp == NULL) {
            error("Could not open file for write\n");
        }
        fprintf(fp, "%d\t%s \r\n",holdvalue,winloss);
        printf("%d\t%s \r\n",holdvalue,winloss);
        fclose(fp);


        wait(3);
        playagain();
        randseed++;
    }// first while loop

}