#ifndef __PINDEF_H__
#define __PINDEF_H__

#ifdef TARGET_LPC1114

// NBCTRLV1 / AYC01

// BUTTON
#define DP_PLAY dp24
#define DP_NEXT dp10
#define DP_PREV dp9

// SPI
#define DP_MOSI dp2
#define DP_MISO dp1
#define DP_SCLK dp6
#define DP_SCS  dp25

// IO
#define DP_IO01 dp13 // P1_4
#define DP_IO02 dp26 // P0_3
#define DP_IO03 dp17 // P1_8
#define DP_IO04 dp4 // P0_11
#define DP_IO05 dp18 // P1_9
#define DP_IO06 dp11 // P1_2

// I2C
#define DP_SDA dp5
#define DP_SCL dp27

// SERIAL
#define DP_TX USBTX
#define DP_RX USBRX

#else

////  TG-LPC11U35

// BUTTON
#define DP_PLAY p20
#define DP_NEXT p19
#define DP_PREV p18

// SPI
#define DP_MOSI p5
#define DP_MISO p6
#define DP_SCLK p7
#define DP_SCS  p8

// IO
#define DP_IO01 p21
#define DP_IO02 p23 
#define DP_IO03 p24 
#define DP_IO04 p25 
#define DP_IO05 p26 
#define DP_IO06 p30 

// I2C
#define DP_SDA p28
#define DP_SCL p27

// SERIAL
#define DP_TX p9
#define DP_RX p10

#endif

#endif