//
// nlg_mini.h
//

#ifndef __NLG_MINI_H__
#define __NLG_MINI_H__

#define CMD_PSG  0x00
#define CMD_OPM  0x01
#define CMD_OPM2 0x02
#define CMD_FM1  0x01
#define CMD_FM2  0x02


#define CMD_IRQ  0x80

#define CMD_CTC0 0x81
#define CMD_CTC3 0x82

#define NLG_VER (110)
#define NLG_BASECLK (4000000)

#define NLG_OK (0)
#define NLG_FILEERR (-1)
#define NLG_UNK_FORMAT (-2)


/* NLGを処理するための構造体 */
typedef struct
{
  FILE *fp;

  int version;

  int baseclk;
  int tick;
  int tick_us;

  int length;

  int ctc0;
  int ctc3;

} NLG_CTX;

int OpenNLG(NLG_CTX *np, const char *filename);
void CloseNLG(NLG_CTX *np);
int ReadNLG(NLG_CTX *np);
long TellNLG(NLG_CTX *np);
void SeekNLG(NLG_CTX *np, long pos);
int GetTickUsNLG(NLG_CTX *np);
void SetCTC0_NLG(NLG_CTX *np, int value);
void SetCTC3_NLG(NLG_CTX *np, int value);
int GetLengthNLG(NLG_CTX *np);
int GetBaseClkNLG(NLG_CTX *np);

#endif
