/*
 * lcd.cpp : AQM0802A mini library
 * 
 *  Based on LCD module "AQM0802A-RN-GBW" sample program  
 *  Copyright (c) 2013 Yoshihiro TSUBOI
 *
 *  Original Arduino version was developed by
 *  Copyright (c) 2013 Masahiro WAKAYAMA at SWITCH SCIENCE
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 */

#include "mbed.h"

I2C i2c(dp5, dp27); // sda, scl

const int AQM0802_addr = 0x7C;

void lcd_cmd(char x)
{
  char data[2];
  data[0] = 0x00; // CO = 0,RS = 0
  data[1] = x;
  i2c.write(AQM0802_addr, data, 2);
}

void lcd_contdata(char x)
{
  char data[2];
  data[0] = 0xC0; //0b11000000 CO = 1, RS = 1
  data[1] = x;
  i2c.write(AQM0802_addr, data, 2);
}

void lcd_lastdata(char x)
{
  char data[2];
  data[0] = 0x40; //0b11000000 CO = 0, RS = 1
  data[1] = x;
  i2c.write(AQM0802_addr, data, 2);
}

void lcd_printStrFill(const char *s)
{
  int idx = 0;
  for(idx = 0; idx < 8; idx++)
  {
    if(idx < 7) {
      lcd_contdata(*s);
    } else {
      lcd_lastdata(*s);
    }
    if (*s) s++;
  }
}


void lcd_printStr(const char *s)
{
  int idx = 0;
  while(*s && idx < 8) {
    if(*(s + 1)) {
      lcd_contdata(*s);
    } else {
      lcd_lastdata(*s);
    }
    s++;
    idx++;
  }
}

void lcd_setContrast(unsigned char c) {
  lcd_cmd(0x39);
  lcd_cmd(0x70 | (c & 0x0f)); // contrast Low
  lcd_cmd(0x5C | ((c >> 4) & 0x03)); // contast High/icon/power
  lcd_cmd(0x38);
}

void lcd_printHex(unsigned char num)
{
  lcd_contdata(num);
}

void lcd_init() {
  int cont = 0;
  wait(0.04);
  // LCD initialize
  lcd_cmd(0x38); // function set
  lcd_cmd(0x39); // function set
  lcd_cmd(0x04); // EntryModeSet
  lcd_cmd(0x14); // interval osc
  lcd_cmd(0x70 | (cont & 0xF)); // contrast Low
  lcd_cmd(0x5C | ((cont >> 4) & 0x3)); // contast High/icon/power
  lcd_cmd(0x6C); // follower control
  wait(0.2);
  lcd_cmd(0x38); // function set
  lcd_cmd(0x0C); // Display On
  lcd_cmd(0x01); // Clear Display
  wait(0.2); // need additional wait to Clear Display
  
  lcd_setContrast(36);

}

void lcd_setCursor(unsigned char x,unsigned char y) {
  lcd_cmd(0x80 | (y * 0x40 + x));
}


void lcd_printStrY(int y,const char *s)
{
  lcd_setCursor(0, y);
  lcd_printStrFill(s);
}

void lcd_printStrYscr(int y,const char *s)
{
  int cnt = strlen(s) - 7;
  if (cnt <= 0)
    cnt = 1;
    
  for(int i = 0; i < cnt; i++)
  {   
    lcd_setCursor(0, y);
    lcd_printStr(s + i);
    wait(0.5);
  }
}


void lcd_printStr2(const char *s, const char *s2)
{
  lcd_setCursor(0,0);
  lcd_printStrFill(s);
  lcd_setCursor(0,1);
  lcd_printStrFill(s2);
}

void lcd_cls(void)
{
    lcd_setCursor(0, 0);
    lcd_printStrFill("");
    lcd_setCursor(0, 1);
    lcd_printStrFill("");
}
    
