#include "mbed.h"
#include "MODSERIAL.h"

Ticker potmeterticker;
DigitalIn button1(D2);
DigitalIn button2(D3);
AnalogIn potmeter(A0);
DigitalOut led(D4);
MODSERIAL pc(USBTX, USBRX);
volatile float pwmvalue;
volatile double pwm_pct;
volatile int on_time_us; // The time the LED should be on, in microseconds
volatile int off_time_us;


void ReadPotmeterValues()
{
    int frequency_Hz = 10000; 
    pwm_pct = potmeter.read() * 100;
    on_time_us = (int) ((pwm_pct/100.0) * (1.0/frequency_Hz) * 1.0e7);
    off_time_us = (int) (( (100.0-pwm_pct)/100.0) * (1.0/frequency_Hz) * 1.0e7);
}

int main()
{
    pc.baud(115200);
    pc.printf("Hello World!\r\n");
    potmeterticker.attach(ReadPotmeterValues, 0.5);
    
    while (true) {
        led = 1;
        pc.printf("%i\r\n",on_time_us);
        wait_us(on_time_us);
        led = 0; // Turn led off
        wait_us(off_time_us);
        //ReadPotmeterValues();
    }
}