#include "mbed.h"
#include "rtos.h"

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);

DigitalIn sw2(SW2);
DigitalIn sw3(SW3);

Serial pc(USBTX, USBRX);

void check_sw2_thread()
{
    while(true) {
        if (sw2 == 0) {
            pc.printf("SW2 button pressed. \n");
            while(sw2 == 0) { // debounce
                Thread::wait(.3);
            }
        }
        Thread::wait(.3);
    }
}

void check_sw3_thread()
{
    while(true) {
        if (sw3 == 0) {
            pc.printf("SW3 button pressed. \n");
            pc.printf("5 characters will be echoed. Start typing. \n");
            for (uint32_t i = 0; i < 5; i++) {
                pc.putc(pc.getc());
            }
            pc.putc(13); /* CR */
            pc.putc(10); /* LF */
        }
        Thread::wait(.3);
    }
}

// Cycle through seven colors
void strobe_led_thread()
{
    while(true) {
        for (int i = 0; i < 8; i++) {
            led_red =   !(i & 0x01);
            led_green = !(i & 0x02);
            led_blue =  !(i & 0x04);
            wait(0.5);
        }
    }
}

int main()
{
    pc.baud(115200);
    pc.printf("Hello World from FRDM-K64F board.\n");

    Thread sw2thread;
    osStatus err = sw2thread.start(&check_sw2_thread);
    if (err) {
        pc.printf("%d", err);
    }

    Thread sw3thread;
    err = sw3thread.start(&check_sw3_thread);
    if (err) {
        pc.printf("%d", err);
    }

    Thread strobethread;
    err = strobethread.start(&strobe_led_thread);
    if (err) {
        pc.printf("%d", err);
    }

    // wait for threads to terminate
    sw2thread.join();
    sw3thread.join();
    strobethread.join();
}
