#ifndef __DETECTION_H_
#define __DETECTION_H__

#include <rgb_sensor_buffer.h>

#define RGB_VALUES (50)

struct Capsule {
    const char* name;
    double r, g, b;
};

class RGB_Detection {

    public:
        RGB_Detection(PinName red, PinName green, PinName blue, PinName adc);
        ~RGB_Detection(void);
        const char *run(void);
        
    protected:
        int match_sample_to_capsule(TRGB& rgb_sample);        
        const Capsule *read_capsule(void);

        RGB_SensorBuffer m_rgb;
        Capsule const *m_last_capsule;
        
        TRGB m_buffer[RGB_VALUES];
        
//    private:
//        static bool __callback(const TRGB &color);
//        bool callback(const TRGB &color);
//        static RGB_Detection *m_global;
};

#endif // __DETECTION_H__
