#include "mbed.h"
#include "gmtime_newlib.h"

Serial console(USBTX, USBRX);

int main() 
{
    console.baud(9600);
    
    // Set time to Tue, 10 Nov 2015 14:00:00 GMT
    set_time(1447164000);

    time_t rawTime;
    time(&rawTime);
    
    // Prints: time_t: 1447164000, h:13773, m:1377, s:537067520
    struct tm *parsedUsingMbed = gmtime(&rawTime);
    console.printf("time_t: %d, h:%d, m:%d, s:%d\r\n", rawTime, parsedUsingMbed->tm_hour, parsedUsingMbed->tm_min, parsedUsingMbed->tm_sec);

    // Prints: time_t: 1447164000, h:14, m:0, s:0
    struct tm parsedUsingNewlib;
    gmtime_newlib(&rawTime, &parsedUsingNewlib);
    console.printf("time_t: %d, h:%d, m:%d, s:%d\r\n", rawTime, parsedUsingNewlib.tm_hour, parsedUsingNewlib.tm_min, parsedUsingNewlib.tm_sec);

    while(1)
        ;
}
