// LSM6DS3 Demo
 
#include "mbed.h"
#include "LSM6DS3.h"
 
LSM6DS3 accel(D4, D5);
 
 DigitalOut led(D13);
Serial pc(USBTX, USBRX);

float xvalues[25], yvalues[25], zvalues[25], x_sum, y_sum, z_sum, x_avg, y_avg, z_avg;
bool fall_waiting = true;
 
int main()
{
       accel.begin(accel.G_SCALE_2000DPS, accel.A_SCALE_8G,
                          accel.G_ODR_1660, accel.A_ODR_6660);
    led = 1;
    
    // fill array initial
    for (int i = 0; i < 25; ++i){   
         accel.readAccel(); 
         xvalues[i] = accel.ax;
         yvalues[i] = accel.ay;
         zvalues[i] = accel.az;
        }
        
        
    while (fall_waiting)
    {
         accel.readAccel();
         xvalues[24] = accel.ax;
         yvalues[24] = accel.ay;
         zvalues[24] = accel.az;
        // for loop that copies down the array
     for (int i = 1; i < 25; ++i){
         
         xvalues[i - 1] = xvalues[i];
         yvalues[i - 1] = yvalues[i];
         zvalues[i - 1] = zvalues[i];
        }
        // clear the sum values
         x_sum = 0;
         y_sum = 0;
         z_sum = 0;
         // average
         for(int in = 0; in < 25; ++in){
             x_sum += xvalues[in]; 
             y_sum += yvalues[in];  
             z_sum += zvalues[in]; 
         }
            x_avg = x_sum / 25;
            y_avg = y_sum / 25;
            z_avg = z_sum / 25;
            
         if(xvalues[24] > x_avg + 1 || yvalues[24] > y_avg + 1 || zvalues[24] > z_avg + 1){
             led = 0;
            fall_waiting = false;
         }
    }
}
 