#ifndef LORA_H_
#define LORA_H_

#include "mbed.h"
#include "mDot.h"

class Lora
{
private:
    mDot* dot;

public:
    Lora();
    /*
    1.name
    2.password
    3.sub band
    4.ACK 0=NULL
    */
    bool setting(string config_network_name, string config_network_pass, uint8_t config_frequency_sub_band,uint8_t config_ACK);    
    bool joinNetwork();
    bool sendData_vector(const std::vector<uint8_t>& data);
    bool sendData_string(std::string& data);
    bool receiveData_string(std::string& output_data);
    mDot* useDot(){return dot;}
        
    
};


#endif 
