#ifndef PARKING_H_
#define PARKING_H_

#include "mbed.h"
#include "mDot.h"
#include "Lora.h"
#include "ADC.h"

class Parking
{
private:   
    const static string SATAE_TITLE;
    const static string EXIST;
    const static string DISAPPEAR;
    
    Lora loraNode1;
    ADC_class sensor1;
    int sleepTime;
    
    bool init();
    bool fill_data();
    std::string findKeyWord(std::string in_string, std::string keyWord);
    //capture();
public:
    Parking(){init(); sleepTime = 30000;}
    int getSleepTime() {return sleepTime;}
    void setSleepTime(int inSleepTime) {sleepTime = inSleepTime;}
    mDot* useDot(){return loraNode1.useDot();}
    Lora* useLora() {return &loraNode1;}
    bool recevie_set_sleeptime();
    bool capture_sent();
    
};

#endif