#include "mbed.h"
#include "ADC.h"
#include "MTSLog.h"


const int ADC_TOTAL_BITS = 16;
const int ADC_bits = 8;
const int ADC_period=50;    
const int ADC_sample_times = 64;
const int ADC_average_move = 6;

AnalogIn Distance(PB_1);

bool ADC_class::init()
{
    movBits = ADC_TOTAL_BITS-ADC_bits;  
    return true;
}

unsigned short ADC_class::sample()
{
    DigitalOut SensorPower(PA_0);
    SensorPower = 0;
    adcDistance = 0;
    for (int i=0;i<ADC_sample_times;i++)
    {
        wait_ms(ADC_period);
        adcDistance += (Distance.read_u16()>>movBits);
    }
   // wait_ms(8000);
    SensorPower = 1;
    
    return adcDistance>>ADC_average_move;
}

bool ADC_class::sample_and_judge_result(unsigned short threshold)
{    
    if(sample()>threshold)
        return true;
    else
        return false; 
}
