#include "SmartAppSingle.h"
#include "mbed.h"
#include "mDot.h"
#include <map>
#include <string>
#include <iostream>

const std::string MIUN::SmartAppSingle::emptyPayload = "";
const int MIUN::SmartAppSingle::defaultPort =  0;

MIUN::SmartAppSingle::SmartAppSingle()
{
}


/*** Running Thread ***/
void MIUN::SmartAppSingle::startRunning()
{
    while(true)
    {
       if(lora.joinNetwork()==true)
       {
            execute(); 
       }
       lora.sleep();
    }
}


/*** public Functions ***/

std::string MIUN::SmartAppSingle::sendReceive(std::string payload, int port, int* receivePort)
{
    if(lora.send(payload,port))
    {
        return lora.receive(receivePort);
    }
    else
    {
        return emptyPayload;
    }
}


void MIUN::SmartAppSingle::setSleepTime(uint32_t inSleepTime)
{
    lora.setSleepTime(inSleepTime);
}

/*** virtual function ***/

uint8_t MIUN::SmartAppSingle::measuredBattery()
{
    return 255;
}

void MIUN::SmartAppSingle::execute()
{
    logInfo("Please overwrite the execute function.");
}