#include "SmartApp.h"
#include "mbed.h"
#include "mDot.h"
#include <map>
#include <string>
#include <iostream>

const std::string MIUN::SmartApp::emptyPayload = "";
const int MIUN::SmartApp::defaultPort =  0;

MIUN::SmartApp::SmartApp()
{
}

/*** Running Thread ***/
void MIUN::SmartApp::startRunning()
{
    while(true)
    {
        //lora.joinNetwork();
       // heartBeat();
       // triggerApp();
        checkInterrupt();
        //lora.setBatteryLevel(measuredBattery());
        lora.sleep();
    }
}


void MIUN::SmartApp::addApp(AppUnit& app)
{
    appMap.insert ( std::pair<uint8_t,AppUnit&>(app.getAppNumber(),app) );
}

void MIUN::SmartApp::showAppMap()
{
    logInfo("Show App:");
    for (std::map<uint8_t,AppUnit&>::iterator it=appMap.begin(); it!=appMap.end(); ++it)
    {
        logInfo("App Number: %u",it->second.getAppNumber());
    }    
}

uint8_t MIUN::SmartApp::measuredBattery()
{
    return 255;
}

/*** Private Functions ***/

void MIUN::SmartApp::heartBeat()
{
    if(AppUnit::hasSendPayload() == true)
    {
        //1. get Send Payload
        SendPayload sendPayload = AppUnit::getSendPayload();
        //2. send
        lora.send(sendPayload.getPayload(),sendPayload.getAppNumber());
    }
    else
    {
        lora.send(emptyPayload,defaultPort);
    }
}


void MIUN::SmartApp::triggerApp()
{
    int port=-1;
    std::string payload = lora.receive(&port); 
    if( payload != emptyPayload && port>defaultPort)
    {
        logInfo("Enter Trigger App");
        logInfo("Payload: %s",payload.c_str());
        logInfo("Port: %d",port);
        for (std::map<uint8_t,AppUnit&>::iterator it=appMap.begin(); it!=appMap.end(); ++it)
        {
            if(it->second.getAppNumber() == port)
            {
                it->second.run(payload);
                break;
            }
            logInfo("App Number: %u",it->second.getAppNumber());
        }   
    }
}

void MIUN::SmartApp::checkInterrupt()
{
    for (std::map<uint8_t,AppUnit&>::iterator it=appMap.begin(); it!=appMap.end(); ++it)
    {
        it->second.interrupt();
    }
}


/********** Test **********/
void MIUN::SmartApp::testThread()
{
    logInfo("--- Test Thread ---");
    //AppUnit app1(1);
    //addApp(app1);
    showAppMap();
    startRunning();
}

void MIUN::SmartApp::testSaveFile()
{
    logInfo("--- Test Save File ---");
    //lora.saveSleepTime(235678901);
    //logInfo("Read Sleep Time: %u", lora.readSleepTime());
    while(true);
}

void MIUN::SmartApp::testSendAndReceive()
{
    logInfo("--- Test Send And Receive ---");
            lora.showInfo();
    while(true)
    {
        lora.joinNetwork();
        lora.showInfo();
        if(lora.send((std::string)"dabin,dabin",1)==true)
        {
            //logInfo("Receive Payload: [%s]", ().c_str(),&i);
        }
        lora.sleep();
        logInfo("---After Sleep---");
    }
}

void MIUN::SmartApp::testMacCommand()
{
    logInfo("--- Test Mac Command ---");
    while(true)
    {
        lora.joinNetwork();
        lora.showInfo();
        lora.getHandler().networkLinkCheck();
        sleep();
        logInfo("---After Sleep---");
    }
}


void MIUN::SmartApp::unConfirmedTest()
{
    logInfo("---unConfirmedTest Test:---");
    lora.changeAck(0);
    lora.showInfo();
    while(true)
    {
        lora.joinNetwork();
        lora.showInfo();
        if(lora.send((std::string)"dabin,dabin",1)==true)
        {
            //logInfo("Receive***************: [%s]", lora.receive().c_str());
        }
        sleep();
        logInfo("---After Sleep---");
    }
}


void MIUN::SmartApp::adaptSFTest()
{
    logInfo("---adapt SF Test:---");
    lora.showInfo();
    while(true)
    {
        lora.joinNetwork();
        lora.showInfo();
        //lora.changeAdaptSF(true);
        //lora.changeSF(20);
        
        if(lora.send((std::string)"dabin,dabin",1)==true)
        {
           // logInfo("Receive***************: [%s]", lora.receive().c_str());
        }
        sleep();
        logInfo("---After Sleep---");
    }
}

void MIUN::SmartApp::setSleepTime(uint32_t inSleepTime)
{
    lora.setSleepTime(inSleepTime);
}

void MIUN::SmartApp::staQuality()
{
    logInfo("---Start Test:---");
    lora.showInfo();
    int total = 0;
    int truely = 0;
    while(true)
    {
        total++;
        lora.joinNetwork();
        lora.showInfo();
        if(lora.send((std::string)"dabin,dabin",1)==true)
        {
            truely++;
        }
        logInfo("*******Statistics Quality:*********:");
        logInfo("Total send: %d",total);
        logInfo("Successful send: %d",truely);
        logInfo("Successful Ratio: %f",(float)truely/total*100);
        logInfo("***********************************");
        sleep();
        logInfo("---After Sleep---");
    }
}