
#ifndef __MIUN_APP_UNIT__
#define __MIUN_APP_UNIT__

#include "mDot.h"
#include <queue>

namespace MIUN
{
    

class SendPayload
{
public:
    SendPayload(std::string payload,uint8_t appNumber):payload(payload),appNumber(appNumber){}
private:
    std::string payload;
    uint8_t appNumber;
public:
    std::string getPayload()
    {
        return payload;
    }
    uint8_t getAppNumber()
    {
        return appNumber;
    }
};
    
class AppUnit
{
/*** constructor ***/
public:
    AppUnit(uint8_t in_appNumber);
    virtual ~AppUnit();
    
private:
    uint8_t appNumber;
    static std::queue<SendPayload> payloadQueue;

/*** Getter Setters ***/
public:
    uint8_t getAppNumber();

/*** Static Handle ***/
public:
    static SendPayload getSendPayload();
    static bool hasSendPayload();
    
/*** Handle ***/
public:
    void send(std::string payload);

/*** Need to be implemented ***/
    virtual void run(std::string payload);
    virtual void interrupt();
};   

    
}

#endif